/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.world.BlocksContainer;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class EntityRendererFallingBlock
extends EntityRenderer<EntityFallingBlock> {
    private final Minecraft mc = Minecraft.getMinecraft();
    private BlocksContainer container = null;

    public EntityRendererFallingBlock() {
        super(0.5f);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityFallingBlock fallingBlock, double x, double y, double z, float yaw, float partialTick) {
        if (this.container == null || this.container.world != fallingBlock.world) {
            this.container = new BlocksContainer(fallingBlock.world);
        }
        GLRenderer.pushFrame();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.setLightmapCoord2f(15.0f, 15.0f);
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        TextureRegistry.worldAtlas.bind();
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.disableState(State.CULL_FACE);
        TilePos blockPos = new TilePos(fallingBlock);
        tessellator.startDrawingQuads();
        tessellator.setTranslation((double)(-blockPos.x) - 0.5, (double)(-blockPos.y) - 0.5, (double)(-blockPos.z) - 0.5);
        this.container.setLightReferenceEntity(fallingBlock);
        this.container.setBlock(blockPos.x, blockPos.y, blockPos.z, fallingBlock.carriedBlock.blockId, fallingBlock.carriedBlock.metadata, fallingBlock.carriedBlock.entity);
        ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.getBlock(fallingBlock.carriedBlock.blockId))).renderNoCulling(GLRenderer.getTessellator(), this.container, blockPos);
        this.container.setLightReferenceEntity(null);
        this.container.clear();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.popFrame();
        TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(fallingBlock.carriedBlock.entity);
        if (renderer != null) {
            GLRenderer.pushFrame();
            renderer.doRender(tessellator, fallingBlock.carriedBlock.entity, x - 0.5, y - 0.5, z - 0.5, partialTick);
            GLRenderer.popFrame();
        }
    }
}

