/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererChicken
extends MobRenderer<MobChicken> {
    public MobRendererChicken(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobChicken entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        float limbPitch = this.getLimbPitch(entity, partialTick);
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform wing0 = model.getTransform("wing0");
        BoneTransform wing1 = model.getTransform("wing1");
        leg0.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        leg1.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        wing0.rotZ = limbPitch;
        wing1.rotZ = -limbPitch;
        return model;
    }

    @Override
    protected float getLimbPitch(@NotNull MobChicken entity, float partialTick) {
        float flap = MathHelper.lerp(entity.oFlap, entity.flap, partialTick);
        float flapSpeed = MathHelper.lerp(entity.oFlapSpeed, entity.flapSpeed, partialTick);
        return (MathHelper.sin(flap) + 1.0f) * flapSpeed;
    }

    @Override
    protected void preRenderTransform(@NotNull MobChicken entity, double x, double y, double z, float yaw, float partialTick) {
        super.preRenderTransform(entity, x, y, z, yaw, partialTick);
        GLRenderer.modelM4f().translate(0.0f, 0.3f, 0.0f);
    }
}

