/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.logic.RailDirection;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelRail<T extends BlockLogicRail>
extends BlockModelStandard<T> {
    protected IconCoordinate railCurve = TextureRegistry.getTexture("minecraft:block/rail/turn");
    protected IconCoordinate powerActive = TextureRegistry.getTexture("minecraft:block/rail_powered/active");
    protected IconCoordinate detectorActive = TextureRegistry.getTexture("minecraft:block/rail_detector/active");

    public BlockModelRail(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        IconCoordinate icon = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        if (BlockModelRail.renderBlocks.overrideBlockTexture != null) {
            icon = BlockModelRail.renderBlocks.overrideBlockTexture;
        }
        RailDirection railDirection = ((BlockLogicRail)this.block.getLogic()).getRailDirection(worldSource, tilePos);
        float brightness = 1.0f;
        tessellator.setLightmapCoord1i(this.block.getLightIndex(worldSource, tilePos));
        if (icon == null) {
            return false;
        }
        tessellator.setColorOpaque3f(brightness, brightness, brightness);
        double minU = icon.getIconUMin();
        double maxU = icon.getIconUMax();
        double minV = icon.getIconVMin();
        double maxV = icon.getIconVMax();
        float yOffset = 0.0625f;
        float vX1 = tilePos.x() + 1;
        float vX2 = tilePos.x() + 1;
        float vX3 = tilePos.x();
        float vX4 = tilePos.x();
        float vZ1 = tilePos.z();
        float vZ2 = tilePos.z() + 1;
        float vZ3 = tilePos.z() + 1;
        float vZ4 = tilePos.z();
        float vY1 = (float)tilePos.y() + 0.0625f;
        float vY2 = (float)tilePos.y() + 0.0625f;
        float vY3 = (float)tilePos.y() + 0.0625f;
        float vY4 = (float)tilePos.y() + 0.0625f;
        switch (railDirection) {
            case STRAIGHT_EW: 
            case SLOPE_E: 
            case SLOPE_W: 
            case TURN_WS: {
                vX1 = vX4 = (float)(tilePos.x() + 1);
                vX2 = vX3 = (float)tilePos.x();
                vZ1 = vZ2 = (float)(tilePos.z() + 1);
                vZ3 = vZ4 = (float)tilePos.z();
                break;
            }
            case TURN_WN: {
                vX1 = vX2 = (float)tilePos.x();
                vX3 = vX4 = (float)(tilePos.x() + 1);
                vZ1 = vZ4 = (float)(tilePos.z() + 1);
                vZ2 = vZ3 = (float)tilePos.z();
                break;
            }
            case TURN_EN: {
                vX1 = vX4 = (float)tilePos.x();
                vX2 = vX3 = (float)(tilePos.x() + 1);
                vZ1 = vZ2 = (float)tilePos.z();
                vZ3 = vZ4 = (float)(tilePos.z() + 1);
            }
        }
        switch (railDirection) {
            case SLOPE_E: 
            case SLOPE_N: {
                vY1 += 1.0f;
                vY4 += 1.0f;
                break;
            }
            case SLOPE_W: 
            case SLOPE_S: {
                vY2 += 1.0f;
                vY3 += 1.0f;
            }
        }
        tessellator.addVertexWithUV(vX1, vY1, vZ1, maxU, minV);
        tessellator.addVertexWithUV(vX2, vY2, vZ2, maxU, maxV);
        tessellator.addVertexWithUV(vX3, vY3, vZ3, minU, maxV);
        tessellator.addVertexWithUV(vX4, vY4, vZ4, minU, minV);
        tessellator.addVertexWithUV(vX4, vY4, vZ4, minU, minV);
        tessellator.addVertexWithUV(vX3, vY3, vZ3, minU, maxV);
        tessellator.addVertexWithUV(vX2, vY2, vZ2, maxU, maxV);
        tessellator.addVertexWithUV(vX1, vY1, vZ1, maxU, minV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (this.block == Blocks.RAIL_POWERED && (data & 8) != 0) {
            return this.powerActive;
        }
        if (this.block == Blocks.RAIL_DETECTOR && (data & 8) != 0) {
            return this.detectorActive;
        }
        if (!((BlockLogicRail)this.block.getLogic()).isPowered && data >= 6) {
            return this.railCurve;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

