/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.OptionVolume;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SoundCategoryHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<SoundCategory, Field> VOLUME_FIELDS = new HashMap();

    public static boolean isAnyEnabled() {
        for (SoundCategory category : SoundCategory.values()) {
            if (!(SoundCategoryHelper.getEffectiveVolume(category) > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public static float getVolume(SoundCategory category) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return 0.0f;
        }
        try {
            return ((Float)((OptionVolume)field.get(null)).value).floatValue();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get volume for category '{}'!", (Object)field.getName(), (Object)e);
            return 0.0f;
        }
    }

    public static float getEffectiveVolume(@NotNull SoundCategory category) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return 0.0f;
        }
        try {
            float value = ((Float)((OptionVolume)field.get(null)).value).floatValue();
            return value * ((Float)GameSettings.MASTER_VOLUME.value).floatValue();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get effective volume for category '{}'!", (Object)field.getName(), (Object)e);
            return 0.0f;
        }
    }

    public static void setVolume(SoundCategory category, float value) {
        Field field = VOLUME_FIELDS.get((Object)category);
        if (field == null) {
            return;
        }
        try {
            OptionVolume option = (OptionVolume)field.get(null);
            option.value = Float.valueOf(value);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set volume for category '{}'!", (Object)field.getName(), (Object)e);
        }
    }

    static {
        try {
            VOLUME_FIELDS.put(SoundCategory.MUSIC, GameSettings.class.getDeclaredField("MUSIC_VOLUME"));
            VOLUME_FIELDS.put(SoundCategory.WORLD_SOUNDS, GameSettings.class.getDeclaredField("WORLD_SOUNDS_VOLUME"));
            VOLUME_FIELDS.put(SoundCategory.WEATHER_SOUNDS, GameSettings.class.getDeclaredField("WEATHER_SOUNDS_VOLUME"));
            VOLUME_FIELDS.put(SoundCategory.ENTITY_SOUNDS, GameSettings.class.getDeclaredField("ENTITY_SOUNDS_VOLUME"));
            VOLUME_FIELDS.put(SoundCategory.CAVE_SOUNDS, GameSettings.class.getDeclaredField("CAVE_SOUNDS_VOLUME"));
            VOLUME_FIELDS.put(SoundCategory.GUI_SOUNDS, GameSettings.class.getDeclaredField("GUI_SOUNDS_VOLUME"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

