/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.RenderBlocks;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.useless.dragonfly.DisplayPos;

public class BlockModelStandard<T extends BlockLogic>
extends BlockModel<T> {
    protected static final RenderBlocks renderBlocks = new RenderBlocks();
    protected static final DisplayPos DEFAULT_BLOCK_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos DEFAULT_BLOCK_GROUND = new DisplayPos(0.0f, 0.1875f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    protected static final DisplayPos DEFAULT_BLOCK_FIXED = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    protected static final DisplayPos DEFAULT_BLOCK_THIRD_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.15625f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f, 0.375f, 0.375f);
    protected static final DisplayPos DEFAULT_BLOCK_THIRD_PERSON_LEFT_HAND = new DisplayPos(0.0f, 0.15625f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f, 0.375f, 0.375f);
    protected static final DisplayPos DEFAULT_BLOCK_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    protected static final DisplayPos DEFAULT_BLOCK_FIRST_PERSON_LEFT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final IconCoordinate BLOCK_TEXTURE_MISSING = TextureRegistry.getTexture("minecraft:block/texture_missing");
    public static final IconCoordinate BLOCK_TEXTURE_UNASSIGNED = TextureRegistry.getTexture("minecraft:block/texture_unassigned");
    @Nullable
    public AABBdc itemRenderBounds = null;
    public int renderLayer = 0;
    protected final TextureLayer blockTextures = new TextureLayer().setAll(BLOCK_TEXTURE_UNASSIGNED);
    @NotNull
    protected @NotNull Map<@NotNull String, @NotNull DisplayPos> displayPosMap = new HashMap<String, DisplayPos>();

    public BlockModelStandard(Block<T> block) {
        super(block);
        this.displayPosMap.put("gui", DEFAULT_BLOCK_GUI);
        this.displayPosMap.put("ground", DEFAULT_BLOCK_GROUND);
        this.displayPosMap.put("fixed", DEFAULT_BLOCK_FIXED);
        this.displayPosMap.put("thirdperson_righthand", DEFAULT_BLOCK_THIRD_PERSON_RIGHT_HAND);
        this.displayPosMap.put("thirdperson_lefthand", DEFAULT_BLOCK_THIRD_PERSON_LEFT_HAND);
        this.displayPosMap.put("firstperson_righthand", DEFAULT_BLOCK_FIRST_PERSON_RIGHT_HAND);
        this.displayPosMap.put("firstperson_lefthand", DEFAULT_BLOCK_FIRST_PERSON_LEFT_HAND);
    }

    @Override
    public boolean renderNoCulling(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        BlockModelStandard.renderBlocks.renderAllFaces = true;
        boolean result = this.render(tessellator, worldSource, tilePos);
        BlockModelStandard.renderBlocks.renderAllFaces = false;
        return result;
    }

    @Override
    public boolean renderWithOverrideTexture(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, IconCoordinate overrideTexture) {
        BlockModelStandard.renderBlocks.overrideBlockTexture = overrideTexture;
        boolean result = this.render(tessellator, worldSource, tilePos);
        BlockModelStandard.renderBlocks.overrideBlockTexture = null;
        return result;
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        return renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos);
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, byte lightIndex) {
        AABBdc bounds = this.getBlockBoundsForItemRender();
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        this.renderBlockWithBounds(tessellator, bounds, metadata, lightIndex, this.getStandaloneTintColor(metadata));
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    public final void renderBlockWithBounds(@NotNull TessellatorGeneral tessellator, @NotNull AABBdc bounds, int metadata, byte lightIndex, int color) {
        tessellator.startDrawingQuads();
        tessellator.setLightmapCoord1i(lightIndex);
        tessellator.setColor1i(color);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
    }

    @Override
    public boolean shouldItemRender3d() {
        return true;
    }

    @Override
    @NotNull
    public DisplayPos getItemDisplayPos(@NotNull String id) {
        return this.displayPosMap.getOrDefault(id, DisplayPos.DEFAULT_DISPLAY_POS);
    }

    @NotNull
    public BlockModelStandard<T> setDisplayPos(@NotNull String id, @NotNull DisplayPos displayPos) {
        this.displayPosMap.put(id, displayPos);
        return this;
    }

    @Deprecated
    @Nullable
    public final IconCoordinate getBlockTexture(@NotNull WorldSource source, int x, int y, int z, @NotNull Side side) {
        return this.getBlockTexture(source, new TilePos(x, y, z), side);
    }

    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, source.getBlockData(tilePos));
    }

    public int getStandaloneTintColor(int metadata) {
        if (BlockModelStandard.renderBlocks.useInventoryTint) {
            return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0) & 0xFFFFFF | 0xFF000000;
        }
        return -1;
    }

    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        return this.blockTextures.get(side);
    }

    @Override
    @Nullable
    public IconCoordinate getParticleTexture(@NotNull Side side, int meta) {
        return this.getBlockTextureFromSideAndMetadata(side, meta);
    }

    @Override
    @Nullable
    public IconCoordinate getOverlayTexture(int meta) {
        return this.getBlockTextureFromSideAndMetadata(Side.NORTH, meta);
    }

    @Deprecated
    public final boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, int x, int y, int z, @NotNull Side side, int meta) {
        return this.shouldSideBeRendered(source, bounds, new TilePos(x, y, z), side, meta);
    }

    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePos tilePos, @NotNull Side side, int meta) {
        return this.shouldSideBeRendered(source, bounds, tilePos, side);
    }

    @Deprecated
    public final boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, int x, int y, int z, @NotNull Side side) {
        return this.shouldSideBeRendered(source, bounds, new TilePos(x, y, z), side);
    }

    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side == Side.BOTTOM && bounds.minY() > 0.0) {
            return true;
        }
        if (side == Side.TOP && bounds.maxY() < 1.0) {
            return true;
        }
        if (side == Side.NORTH && bounds.minZ() > 0.0) {
            return true;
        }
        if (side == Side.SOUTH && bounds.maxZ() < 1.0) {
            return true;
        }
        if (side == Side.WEST && bounds.minX() > 0.0) {
            return true;
        }
        if (side == Side.EAST && bounds.maxX() < 1.0) {
            return true;
        }
        return !source.isBlockOpaqueCube(tilePos);
    }

    public boolean shouldSideBeColored(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Side side, int meta) {
        return true;
    }

    @Override
    public int particleColorIndex(@NotNull WorldSource worldSource, @NotNull TilePosc tilePos, @NotNull Side side, int meta) {
        return this.shouldSideBeColored(worldSource, tilePos, side, meta) ? 0 : -1;
    }

    @NotNull
    public AABBdc getBlockBoundsForItemRender() {
        if (this.itemRenderBounds != null) {
            return this.itemRenderBounds;
        }
        return this.block.getBounds();
    }

    @Override
    public int renderLayer() {
        return this.renderLayer;
    }

    public BlockModelStandard<T> onRenderLayer(int layer) {
        this.renderLayer = layer;
        return this;
    }

    public BlockModelStandard<T> withCustomItemBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.itemRenderBounds = new AABBd(minX, minY, minZ, maxX, maxY, maxZ);
        return this;
    }

    public BlockModelStandard<T> setTex(@Nullable IconCoordinate coordinate, Side ... sides) {
        this.blockTextures.set(coordinate, sides);
        return this;
    }

    public BlockModelStandard<T> setTex(@Nullable String texture, Side ... sides) {
        this.blockTextures.set(texture, sides);
        return this;
    }

    public BlockModelStandard<T> setAllTextures(@Nullable IconCoordinate coordinate) {
        this.blockTextures.setAll(coordinate);
        return this;
    }

    public BlockModelStandard<T> setAllTextures(@Nullable String texture) {
        this.blockTextures.setAll(texture);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String texture) {
        this.blockTextures.setAll(texture);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTopBottom, String textureSides) {
        this.blockTextures.set(textureTopBottom, Side.TOP, Side.BOTTOM).set(textureSides, Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureSides) {
        this.blockTextures.set(textureTop, Side.TOP).set(textureBottom, Side.BOTTOM).set(textureSides, Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureNorth, String textureEast, String textureSouth, String textureWest) {
        this.blockTextures.set(textureTop, Side.TOP).set(textureBottom, Side.BOTTOM).set(textureNorth, Side.NORTH).set(textureEast, Side.EAST).set(textureSouth, Side.SOUTH).set(textureWest, Side.WEST);
        return this;
    }

    protected static class TextureLayer {
        private final @Nullable IconCoordinate @NotNull [] coordinates = new IconCoordinate[6];
        private boolean hasTexture = false;

        protected TextureLayer() {
        }

        public TextureLayer set(@Nullable IconCoordinate coordinate, Side ... sides) {
            for (Side s : sides) {
                assert (s != Side.NONE) : "Cannot set texture on a 'NONE' side!";
                this.coordinates[s.getId()] = coordinate;
            }
            this.hasTexture = false;
            for (IconCoordinate iconCoordinate : this.coordinates) {
                this.hasTexture |= iconCoordinate != null;
            }
            return this;
        }

        public TextureLayer set(@Nullable String texture, Side ... sides) {
            return this.set(texture == null ? null : TextureRegistry.getTexture(texture), sides);
        }

        public TextureLayer setAll(@Nullable IconCoordinate coordinate) {
            Arrays.fill(this.coordinates, coordinate);
            this.hasTexture = coordinate != null;
            return this;
        }

        public TextureLayer setAll(@Nullable String texture) {
            return this.setAll(texture == null ? null : TextureRegistry.getTexture(texture));
        }

        public TextureLayer copy(@NotNull TextureLayer layer) {
            System.arraycopy(layer.coordinates, 0, this.coordinates, 0, 6);
            this.hasTexture = layer.hasTexture;
            return this;
        }

        @Nullable
        public IconCoordinate get(@NotNull Side side) {
            assert (side != Side.NONE) : "Cannot set texture on a 'NONE' side!";
            return this.coordinates[side.getId()];
        }

        @Nullable
        public IconCoordinate get(int index) {
            assert (index >= 0) : "Index must be greater then or equal to 0!";
            assert (index < this.coordinates.length) : "Index must be less then " + this.coordinates.length + "!";
            return this.coordinates[index];
        }

        public boolean hasTexture() {
            return this.hasTexture;
        }
    }
}

