/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.List;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.RenderDoubleBase;
import net.minecraft.client.render.font.RenderDoubleConstrainedBase;
import net.minecraft.client.render.font.RenderIntegerBase;
import net.minecraft.client.render.font.RenderIntegerConstrainedBase;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FontRenderer {
    protected static final long CONFIG_DEFAULT = 0xFFFFFFFFL;
    @NotNull
    protected static final String NULL_STRING = String.valueOf(null);
    private static final RenderIntegerBase method_render = new RenderIntegerBase(){

        @Override
        public void call() {
            this.fontRenderer.renderImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleBase method_renderDouble = new RenderDoubleBase(){

        @Override
        public void call() {
            this.fontRenderer.renderDoubleImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerBase method_renderCentered = new RenderIntegerBase(){

        @Override
        public void call() {
            this.fontRenderer.renderCenteredImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleBase method_renderCenteredDouble = new RenderDoubleBase(){

        @Override
        public void call() {
            this.fontRenderer.renderCenteredDoubleImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerConstrainedBase method_renderWidthConstrained = new RenderIntegerConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderWidthConstrainedImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleConstrainedBase method_renderWidthConstrainedDouble = new RenderDoubleConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderWidthConstrainedDoubleImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderIntegerConstrainedBase method_renderConstrained = new RenderIntegerConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderConstrainedImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.maxHeight, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private static final RenderDoubleConstrainedBase method_renderConstrainedDouble = new RenderDoubleConstrainedBase(){

        @Override
        public void call() {
            this.fontRenderer.renderConstrainedDoubleImpl(this.font, this.chars, this.x, this.y, this.z, this.shadow, this.config, this.maxWidth, this.maxHeight, this.alignment, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
            this.needCall = false;
        }
    };
    private final double @NotNull [] xPosBuffer = new double[1];
    private final double @NotNull [] yPosBuffer = new double[1];
    private final long @NotNull [] configBuffer = new long[1];

    abstract void renderImpl(@NotNull Font var1, @NotNull CharSequence var2, int var3, int var4, double var5, boolean var7, long var8, double @Nullable [] var10, double @Nullable [] var11, long @Nullable [] var12);

    @NotNull
    public final RenderIntegerBase render(@Nullable Object o, int x, int y) {
        return this.render(String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderIntegerBase render(boolean b, int x, int y) {
        return method_render.init(this, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(int i, int x, int y) {
        return method_render.init(this, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(long l, int x, int y) {
        return method_render.init(this, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(char c, int x, int y) {
        return method_render.init(this, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(float f, int x, int y) {
        return method_render.init(this, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(double d, int x, int y) {
        return method_render.init(this, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(char @Nullable [] cArr, int x, int y) {
        return method_render.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase render(@Nullable CharSequence chars, int x, int y) {
        return method_render.init(this, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderDoubleImpl(@NotNull Font var1, @NotNull CharSequence var2, double var3, double var5, double var7, boolean var9, long var10, double @Nullable [] var12, double @Nullable [] var13, long @Nullable [] var14);

    @NotNull
    public final RenderDoubleBase renderDouble(@Nullable Object o, double x, double y) {
        return this.renderDouble(String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(boolean b, double x, double y) {
        return method_renderDouble.init(this, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(int i, double x, double y) {
        return method_renderDouble.init(this, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(long l, double x, double y) {
        return method_renderDouble.init(this, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(char c, double x, double y) {
        return method_renderDouble.init(this, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(float f, double x, double y) {
        return method_renderDouble.init(this, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(double d, double x, double y) {
        return method_renderDouble.init(this, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(char @Nullable [] cArr, double x, double y) {
        return method_renderDouble.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderDouble(@Nullable CharSequence chars, double x, double y) {
        return method_renderDouble.init(this, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderCenteredImpl(@NotNull Font var1, @NotNull CharSequence var2, int var3, int var4, double var5, boolean var7, long var8, double @Nullable [] var10, double @Nullable [] var11, long @Nullable [] var12);

    @NotNull
    public final RenderIntegerBase renderCentered(@Nullable Object o, int x, int y) {
        return this.renderCentered(String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(boolean b, int x, int y) {
        return method_renderCentered.init(this, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(int i, int x, int y) {
        return method_renderCentered.init(this, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(long l, int x, int y) {
        return method_renderCentered.init(this, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(char c, int x, int y) {
        return method_renderCentered.init(this, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(float f, int x, int y) {
        return method_renderCentered.init(this, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(double d, int x, int y) {
        return method_renderCentered.init(this, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(char @Nullable [] cArr, int x, int y) {
        return method_renderCentered.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerBase renderCentered(@Nullable CharSequence chars, int x, int y) {
        return method_renderCentered.init(this, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderCenteredDoubleImpl(@NotNull Font var1, @NotNull CharSequence var2, double var3, double var5, double var7, boolean var9, long var10, double @Nullable [] var12, double @Nullable [] var13, long @Nullable [] var14);

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@Nullable Object o, double x, double y) {
        return this.renderCenteredDouble(String.valueOf(o), x, y);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(boolean b, double x, double y) {
        return method_renderCenteredDouble.init(this, Boolean.toString(b), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(int i, double x, double y) {
        return method_renderCenteredDouble.init(this, Integer.toString(i), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(long l, double x, double y) {
        return method_renderCenteredDouble.init(this, Long.toString(l), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(char c, double x, double y) {
        return method_renderCenteredDouble.init(this, String.valueOf(c), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(float f, double x, double y) {
        return method_renderCenteredDouble.init(this, Float.toString(f), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(double d, double x, double y) {
        return method_renderCenteredDouble.init(this, Double.toString(d), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(char @Nullable [] cArr, double x, double y) {
        return method_renderCenteredDouble.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleBase renderCenteredDouble(@Nullable CharSequence chars, double x, double y) {
        return method_renderCenteredDouble.init(this, chars == null ? NULL_STRING : chars, x, y, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderWidthConstrainedImpl(@NotNull Font var1, @NotNull CharSequence var2, int var3, int var4, double var5, boolean var7, long var8, int var10, @NotNull Alignment var11, double @Nullable [] var12, double @Nullable [] var13, long @Nullable [] var14);

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@Nullable Object o, int x, int y, int maxWidth) {
        return this.renderWidthConstrained(String.valueOf(o), x, y, maxWidth);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(boolean b, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, Boolean.toString(b), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(int i, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, Integer.toString(i), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(long l, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, Long.toString(l), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(char c, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, String.valueOf(c), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(float f, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, Float.toString(f), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(double d, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, Double.toString(d), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(char @Nullable [] cArr, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderWidthConstrained(@Nullable CharSequence chars, int x, int y, int maxWidth) {
        return method_renderWidthConstrained.init(this, chars == null ? NULL_STRING : chars, x, y, maxWidth, Integer.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderWidthConstrainedDoubleImpl(@NotNull Font var1, @NotNull CharSequence var2, double var3, double var5, double var7, boolean var9, long var10, double var12, @NotNull Alignment var14, double @Nullable [] var15, double @Nullable [] var16, long @Nullable [] var17);

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@Nullable Object o, double x, double y, double maxWidth) {
        return this.renderWidthConstrainedDouble(String.valueOf(o), x, y, maxWidth);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(boolean b, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, Boolean.toString(b), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(int i, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, Integer.toString(i), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(long l, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, Long.toString(l), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(char c, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, String.valueOf(c), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(float f, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, Float.toString(f), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(double d, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, Double.toString(d), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(char @Nullable [] cArr, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderWidthConstrainedDouble(@Nullable CharSequence chars, double x, double y, double maxWidth) {
        return method_renderWidthConstrainedDouble.init(this, chars == null ? NULL_STRING : chars, x, y, maxWidth, Double.MAX_VALUE, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderConstrainedImpl(@NotNull Font var1, @NotNull CharSequence var2, int var3, int var4, double var5, boolean var7, long var8, int var10, int var11, @NotNull Alignment var12, double @Nullable [] var13, double @Nullable [] var14, long @Nullable [] var15);

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@Nullable Object o, int x, int y, int maxWidth, int maxHeight) {
        return this.renderConstrained(String.valueOf(o), x, y, maxWidth, maxHeight);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(boolean b, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, Boolean.toString(b), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(int i, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, Integer.toString(i), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(long l, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, Long.toString(l), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(char c, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, String.valueOf(c), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(float f, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, Float.toString(f), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(double d, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, Double.toString(d), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(char @Nullable [] cArr, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderIntegerConstrainedBase renderConstrained(@Nullable CharSequence chars, int x, int y, int maxWidth, int maxHeight) {
        return method_renderConstrained.init(this, chars == null ? NULL_STRING : chars, x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    abstract void renderConstrainedDoubleImpl(@NotNull Font var1, @NotNull CharSequence var2, double var3, double var5, double var7, boolean var9, long var10, double var12, double var14, @NotNull Alignment var16, double @Nullable [] var17, double @Nullable [] var18, long @Nullable [] var19);

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@Nullable Object o, double x, double y, double maxWidth, double maxHeight) {
        return this.renderConstrainedDouble(String.valueOf(o), x, y, maxWidth, maxHeight);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(boolean b, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, Boolean.toString(b), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(int i, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, Integer.toString(i), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(long l, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, Long.toString(l), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(char c, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, String.valueOf(c), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(float f, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, Float.toString(f), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(double d, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, Double.toString(d), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(char @Nullable [] cArr, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, cArr == null ? NULL_STRING : new String(cArr), x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    @NotNull
    public final RenderDoubleConstrainedBase renderConstrainedDouble(@Nullable CharSequence chars, double x, double y, double maxWidth, double maxHeight) {
        return method_renderConstrainedDouble.init(this, chars == null ? NULL_STRING : chars, x, y, maxWidth, maxHeight, this.xPosBuffer, this.yPosBuffer, this.configBuffer);
    }

    public final int getLastEndingX() {
        return MathHelper.ceil(this.xPosBuffer[0]);
    }

    public final double getLastEndingXDouble() {
        return this.xPosBuffer[0];
    }

    public final int getLastEndingY() {
        return MathHelper.ceil(this.yPosBuffer[0]);
    }

    public final double getLastEndingYDouble() {
        return this.yPosBuffer[0];
    }

    public final long getLastConfig() {
        return this.configBuffer[0];
    }

    @NotNull
    public abstract List<String> splitCharsIntoLines(@NotNull Font var1, @NotNull CharSequence var2, double var3, @Nullable List<String> var5);

    @NotNull
    public List<String> splitCharsIntoLines(@NotNull CharSequence chars, double maxWidth, @Nullable List<String> output) {
        return this.splitCharsIntoLines(this.getFont(), chars, maxWidth, output);
    }

    @NotNull
    public abstract List<String> splitLinesIntoConstrainedLines(@NotNull Font var1, @NotNull List<String> var2, double var3, @Nullable List<String> var5);

    @NotNull
    public List<String> splitLinesIntoConstrainedLines(@NotNull List<String> lines, double maxWidth, @Nullable List<String> output) {
        return this.splitLinesIntoConstrainedLines(this.getFont(), lines, maxWidth, output);
    }

    public abstract double heightOfConstrainedChars(@NotNull Font var1, @NotNull CharSequence var2, double var3);

    public double heightOfConstrainedChars(@NotNull CharSequence chars, double maxWidth) {
        return this.heightOfConstrainedChars(this.getFont(), chars, maxWidth);
    }

    public abstract double heightOfLines(@NotNull Font var1, @NotNull List<String> var2, double var3);

    public double heightOfLines(@NotNull List<String> lines, double maxWidth) {
        return this.heightOfLines(this.getFont(), lines, maxWidth);
    }

    @NotNull
    public abstract Font getFont();

    public abstract double stringWidthDouble(@NotNull Font var1, @NotNull CharSequence var2);

    public int stringWidth(@NotNull Font font, @NotNull CharSequence chars) {
        return MathHelper.ceil(this.stringWidthDouble(font, chars));
    }

    public double stringWidthDouble(@NotNull CharSequence chars) {
        return this.stringWidthDouble(this.getFont(), chars);
    }

    public int stringWidth(@NotNull CharSequence chars) {
        return this.stringWidth(this.getFont(), chars);
    }

    public void init() {
    }
}

