/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.overworld;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGeneratorLerp;
import net.minecraft.core.world.generate.chunk.perlin.overworld.DensityGeneratorOverworld;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;

public class TerrainGeneratorOverworld
extends TerrainGeneratorLerp {
    private final DensityGenerator densityGenerator;
    private final int minY;
    private final int maxY;

    protected TerrainGeneratorOverworld(@NotNull World world, @NotNull DensityGenerator densityGenerator) {
        super(world);
        this.densityGenerator = densityGenerator;
        this.minY = world.getWorldType().getMinY(world);
        this.maxY = world.getWorldType().getMaxY(world);
    }

    public TerrainGeneratorOverworld(@NotNull World world) {
        this(world, new DensityGeneratorOverworld(world));
    }

    @Override
    protected int getBlockAt(@NotNull Chunk chunk, int x, int y, int z, double density) {
        WorldType type = this.world.getWorldType();
        if (y <= this.minY + this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (density > 0.0) {
            return type.getFillerBlockId();
        }
        if (y >= this.minY && y < this.minY + type.getOceanY()) {
            return type.getOceanBlockId();
        }
        return 0;
    }

    @Override
    @NotNull
    public DensityGenerator getDensityGenerator() {
        return this.densityGenerator;
    }
}

