/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkTilePos;
import org.jetbrains.annotations.NotNull;
import org.useless.seedviewer.bta.BTABiome;
import org.useless.seedviewer.data.ViewerBiome;
import org.useless.seedviewer.data.ViewerChunk;

public class BTAComplexChunk
implements ViewerChunk {
    private final Chunk chunk;
    private final BiomeProvider provider;

    public BTAComplexChunk(@NotNull Chunk chunk, BiomeProvider biomeProvider) {
        this.chunk = chunk;
        this.provider = biomeProvider;
    }

    @Override
    public ViewerBiome getBiome(ChunkTilePos pos) {
        Biome b = this.chunk.getBlockBiome(pos);
        if (b != null) {
            return new BTABiome(b);
        }
        return new BTABiome(this.provider.getBiome(this.chunk.pos.x * 16 + pos.x, pos.y, this.chunk.pos.z * 16 + pos.z));
    }

    @Override
    public int getBlockColor(ChunkTilePos pos) {
        Block<?> b = Blocks.getBlock(this.chunk.getBlockId(pos));
        if (b == null) {
            return 0;
        }
        int meta = this.chunk.getBlockData(pos);
        return MaterialColor.getColorFromIndex(MaterialColor.getColorIndexFromBlock(b, meta)) | 0xFF000000;
    }

    @Override
    public int getHeight(ChunkTilePos pos) {
        return this.chunk.getHeightValue(pos.x, pos.z);
    }

    @Override
    public int getWaterDepth(ChunkTilePos pos) {
        Block<?> b;
        int y;
        int start = this.getHeight(pos) - 1;
        int depth = 0;
        while ((y = start - depth) >= 0 && (b = Blocks.getBlock(this.chunk.getBlockId(new ChunkTilePos(pos.x, y, pos.z)))) != null && b.getMaterial() == Materials.WATER) {
            ++depth;
        }
        return depth;
    }
}

