/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.gui.Screen;

public class ListLayout {
    public final Screen screen;
    public final List<GuiElement> elements = new ArrayList<GuiElement>();
    public double alignX = 0.0;
    public double alignY = 0.0;
    public double alignSelfX = 0.0;
    public double alignSelfY = 0.0;
    public int offsetX;
    public int offsetY;
    public boolean vertical = true;
    public int margin = 0;
    public int elementWidth = 200;
    public int elementHeight = 20;

    public ListLayout(Screen screen) {
        this.screen = screen;
    }

    public ListLayout addElement(GuiElement element) {
        this.elements.add(element);
        return this;
    }

    public void updateElementPositions() {
        int listHeight;
        int listWidth;
        int elementCount = this.elements.size();
        if (this.vertical) {
            listWidth = this.elementWidth;
            listHeight = this.elementHeight * elementCount + (elementCount - 1) * this.margin;
        } else {
            listWidth = this.elementWidth * elementCount + (elementCount - 1) * this.margin;
            listHeight = this.elementHeight;
        }
        int listX = ListLayout.mix(0, this.screen.width, this.alignX) + this.offsetX;
        int listY = ListLayout.mix(0, this.screen.height, this.alignY) + this.offsetY;
        listX += ListLayout.mix(0, -listWidth, this.alignSelfX);
        listY += ListLayout.mix(0, -listHeight, this.alignSelfY);
        for (int i = 0; i < this.elements.size(); ++i) {
            GuiElement element = this.elements.get(i);
            element.setWidth(this.elementWidth);
            element.setHeight(this.elementHeight);
            if (this.vertical) {
                element.setX(listX);
                element.setY(listY + i * this.elementHeight + i * this.margin);
                continue;
            }
            element.setX(listX + i * this.elementWidth + i * this.margin);
            element.setY(listY);
        }
    }

    public static int mix(int a, int b, double c) {
        return (int)((double)a * (1.0 - c) + (double)b * c);
    }

    public ListLayout setAlign(double x, double y) {
        this.alignX = x;
        this.alignY = y;
        return this;
    }

    public ListLayout setVertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    public ListLayout setElementSize(int width, int height) {
        this.elementWidth = width;
        this.elementHeight = height;
        return this;
    }

    public ListLayout setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public ListLayout setMargin(int margin) {
        this.margin = margin;
        return this;
    }
}

