/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryComponent
implements PageComponent {
    private static final Minecraft MC = Minecraft.getMinecraft();
    private static final ItemElement RENDER_ITEM = new ItemElement(MC);
    private static final int PADDING = 2;
    private static final int TOP_SPACING = 24;
    private static final int COMPONENT_LEFT_MARGIN = 16;
    @NotNull
    private final Text label;
    @Nullable
    private final ItemStack icon;
    @NotNull
    private final @NotNull List<@NotNull PageComponent> components = new ArrayList<PageComponent>();
    @Nullable
    private PageComponent clickedComponent = null;
    private int clickedComponentY = 0;
    private boolean collapsed = false;

    public CategoryComponent(@NotNull Text label, @Nullable ItemStack icon) {
        this.label = label;
        this.icon = icon;
    }

    public CategoryComponent(@NotNull Text label) {
        this(label, null);
    }

    @NotNull
    public CategoryComponent withComponent(@NotNull PageComponent component) {
        this.components.add(component);
        return this;
    }

    @Override
    public void tick() {
        for (PageComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public int getHeight() {
        int height = 24;
        if (!this.collapsed) {
            for (PageComponent component : this.components) {
                height += component.getHeight();
            }
        }
        return height;
    }

    @Override
    public void render(@NotNull ScreenPaged screen, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        int textColor = 0x7F7F7F;
        CategoryComponent.MC.font.render(this.collapsed ? "\u25b7" : "\u25bd", x, y + 2 + 10).setShadow().setColor(0x7F7F7F).call();
        int xOffset = 10;
        if (this.icon != null) {
            RENDER_ITEM.render(this.icon, x + 11, y + 2 + 5);
            xOffset += 20;
        }
        CategoryComponent.MC.font.render(this.label.toString(), x + xOffset, y + 2 + 10).setShadow().setColor(0x7F7F7F).call();
        if (!this.collapsed) {
            int componentY = 24;
            for (PageComponent component : this.components) {
                if (y + componentY + component.getHeight() >= screen.top() && y + componentY <= screen.bottom()) {
                    component.render(screen, x + 16, y + componentY, width - 16, relativeMouseX - 16, relativeMouseY - componentY);
                }
                componentY += component.getHeight();
            }
        }
    }

    @Override
    public boolean onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (relativeMouseX >= 0 && relativeMouseX < width && relativeMouseY >= 0 && relativeMouseY < 24) {
            this.collapsed = !this.collapsed;
            CategoryComponent.MC.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        int componentY = 24;
        for (PageComponent component : this.components) {
            if (relativeMouseX >= 16 && relativeMouseX < width && relativeMouseY >= componentY && relativeMouseY < componentY + component.getHeight()) {
                component.onMouseClick(mouseButton, x + 16, componentY, width - 16, relativeMouseX - 16, relativeMouseY - componentY);
                this.clickedComponent = component;
                this.clickedComponentY = componentY;
                return true;
            }
            componentY += component.getHeight();
        }
        return false;
    }

    @Override
    public boolean onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            return this.clickedComponent.onMouseMove(x + 16, this.clickedComponentY, width - 16, relativeMouseX - 16, relativeMouseY - this.clickedComponentY);
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            return this.clickedComponent.onMouseRelease(mouseButton, x + 16, this.clickedComponentY, width - 16, relativeMouseX - 16, relativeMouseY - this.clickedComponentY);
        }
        return false;
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        for (PageComponent component : this.components) {
            component.onKeyPress(keyCode, character);
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }
}

