/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericSlabPainted<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel[] upper = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] lower = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] full = new StaticBlockModel[16];

    public BlockModelGenericSlabPainted(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/white/lower"));
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.upper[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/" + color.colorID + "/upper").asModel();
            this.lower[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/" + color.colorID + "/lower").asModel();
            this.full[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/slab/planks/" + color.colorID + "/full").asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        int color = data >> 4 & 0xF;
        return switch (data & 3) {
            case 1 -> this.full[color];
            case 2 -> this.upper[color];
            default -> this.lower[color];
        };
    }
}

