/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.pos.TilePos;

public class DynamicTextureCompass
extends DynamicTexture {
    private final Minecraft mc;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;

    public DynamicTextureCompass(Minecraft minecraft, IconCoordinate iconCoordinate) {
        super(iconCoordinate);
        this.mc = minecraft;
    }

    @Override
    public void postInit() {
        this.initTexture();
        BufferedImage atlas = this.targetTexture.parentAtlas.colorImage;
        this.compassImageData = new byte[this.targetTexture.getArea() * 4];
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.targetTexture.height; ++y) {
                DynamicTextureCompass.putPixel(this.compassImageData, y * this.targetTexture.width + x, atlas.getRGB(this.targetTexture.iconX + x, this.targetTexture.iconY + y));
            }
        }
        this.scaleFactor = (double)this.targetTexture.width / 16.0;
    }

    @Override
    public boolean runUpdates(boolean isPaused) {
        return !isPaused;
    }

    @Override
    public void update() {
        int a;
        int b;
        int g;
        int r;
        int j;
        int y2;
        int x2;
        int i;
        double angleSmooth;
        for (int _x = 0; _x < this.targetTexture.width; ++_x) {
            for (int _y = 0; _y < this.targetTexture.height; ++_y) {
                int i2 = _y * this.targetTexture.width + _x;
                int a2 = this.compassImageData[i2 * 4 + 3] & 0xFF;
                int r2 = this.compassImageData[i2 * 4] & 0xFF;
                int g2 = this.compassImageData[i2 * 4 + 1] & 0xFF;
                int b2 = this.compassImageData[i2 * 4 + 2] & 0xFF;
                this.imageData[i2 * 4] = (byte)r2;
                this.imageData[i2 * 4 + 1] = (byte)g2;
                this.imageData[i2 * 4 + 2] = (byte)b2;
                this.imageData[i2 * 4 + 3] = (byte)a2;
            }
        }
        double angle = 0.0;
        if (this.mc.currentWorld != null && this.mc.thePlayer != null) {
            TilePos spawnPoint = this.mc.currentWorld.getSpawnPoint();
            double dx = (double)spawnPoint.x - this.mc.thePlayer.x;
            double dz = (double)spawnPoint.z - this.mc.thePlayer.z;
            angle = (double)(this.mc.thePlayer.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(dz, dx);
            if (this.mc.currentWorld.dimension == Dimension.NETHER) {
                angle = Math.random() * Math.PI * 2.0;
            }
        }
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        double xs = (double)this.targetTexture.width / 2.0 + 0.5;
        double ys = (double)this.targetTexture.height / 2.0 - 0.5;
        for (i = (int)(-4.0 * this.scaleFactor); i <= (int)(4.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + y * (double)i * 0.3);
            y2 = (int)(ys - x * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            this.imageData[j * 4] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
        for (i = (int)(-8.0 * this.scaleFactor); i <= (int)(16.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + x * (double)i * 0.3);
            y2 = (int)(ys + y * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            r = i >= 0 ? 255 : 100;
            g = i >= 0 ? 20 : 100;
            b = i >= 0 ? 20 : 100;
            a = 255;
            this.imageData[j * 4] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }
}

