/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererHuman
extends MobRendererBiped<MobHuman> {
    public MobRendererHuman() {
        super(0.5f);
    }

    @Override
    protected void preRenderTransform(@NotNull MobHuman entity, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        GLRenderer.modelM4f().rotateY(-this.getBodyYaw(entity, partialTick));
        GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
        float scale = 0.9375f;
        GLRenderer.modelM4f().scale(0.9375f, 0.9375f, 0.9375f);
        if (entity.deathTime > 0) {
            float rotationProgress = ((float)entity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GLRenderer.modelM4f().rotateZ(Math.toRadians(rotationProgress * this.getMaxDeathRotation(entity)));
        }
    }

    @Override
    public void loadEntityTexture(@NotNull MobHuman entity) {
        this.bindDownloadableTexture(entity.skinUrl, entity.getEntityTexture(), entity.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
    }

    @Override
    @Nullable
    protected StaticEntityModel getActiveModel(@NotNull MobHuman entity) {
        MobRendererPlayer.Specials specials = MobRendererPlayer.Specials.getSpecialsForMob(entity);
        if (specials != null) {
            return this.getModel(specials.mainModelReference);
        }
        return entity.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }
}

