/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.client.render.shader.ShaderProvider;
import org.slf4j.Logger;

public class ShaderProviderExternal
implements ShaderProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File dir;

    public ShaderProviderExternal(File dir) {
        this.dir = dir;
    }

    @Override
    public String getShaderSource(String name) {
        File file = new File(this.dir, name);
        if (!file.exists()) {
            LOGGER.error("File {} does not exist!", (Object)file.getAbsolutePath());
            return null;
        }
        try {
            return StringUtils.getFileContentAsString(file);
        }
        catch (Exception e) {
            LOGGER.error("Exception reading shader file '{}'!", (Object)file.getPath(), (Object)e);
            return null;
        }
    }
}

