/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLog;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLeavesBase
extends BlockLogic {
    public static final int MASK_DECAY_DATA = 15;
    public static final int NUM_DECAY_BITS = 4;
    public static final int DECAY_FLAG_BIT = 3;
    public static final int PERMANENT_FLAG_BIT = 0;
    public static boolean enableTreeShadowing = false;
    public static boolean enableDecay = true;
    int[] adjacentTreeBlocks;
    protected Block<?> sapling;

    public BlockLogicLeavesBase(@NotNull Block<?> block, @NotNull Material material, @NotNull Block<?> sapling) {
        super(block, material);
        block.setTicking(true);
        this.sapling = sapling;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        float dropRate = 20.0f;
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this.block)};
        }
        int numDropped = 1;
        if (world.rand.nextInt(MathHelper.floor(dropRate)) != 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this.getSapling(), numDropped)};
    }

    protected Block<?> getSapling() {
        return this.sapling;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (!enableDecay) {
            return;
        }
        int radius = 1;
        int chunkRadius = radius + 1;
        if (world.areBlocksLoaded((TilePosc)tilePos.add(-chunkRadius, -chunkRadius, -chunkRadius, new TilePos()), tilePos.add(chunkRadius, chunkRadius, chunkRadius, new TilePos()))) {
            TilePos p = new TilePos(tilePos);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        int meta;
                        p.set(tilePos.x() + dx, tilePos.y() + dy, tilePos.z() + dz);
                        Block<?> block = world.getBlockType(p);
                        if (block == null || !(block.getLogic() instanceof BlockLogicLeavesBase) || BlockLogicLeavesBase.isPermanent(meta = world.getBlockData(p))) continue;
                        world.setBlockData(p, BlockLogicLeavesBase.setDecaying(meta, true));
                    }
                }
            }
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        if (BlockLogicLeavesBase.isDecaying(meta) && !BlockLogicLeavesBase.isPermanent(meta)) {
            int radius = 4;
            int offset = radius + 1;
            int ySpan = 32;
            int xSpan = ySpan * ySpan;
            int halfLength = ySpan / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[ySpan * ySpan * ySpan];
            }
            if (world.areBlocksLoaded((TilePosc)tilePos.add(-offset, -offset, -offset, new TilePos()), tilePos.add(offset, offset, offset, new TilePos()))) {
                TilePos p = new TilePos(tilePos);
                for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
                    for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                        for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                            Block<?> block = world.getBlockType(p.set(tilePos.x() + xOffset, tilePos.y() + yOffset, tilePos.z() + zOffset));
                            int i = (xOffset + halfLength) * xSpan + (yOffset + halfLength) * ySpan + (zOffset + halfLength);
                            this.adjacentTreeBlocks[i] = block != null && block.getLogic() instanceof BlockLogicLog ? 0 : (block != null && block.getLogic() instanceof BlockLogicLeavesBase ? -2 : -1);
                        }
                    }
                }
                for (int j = 1; j <= 4; ++j) {
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dy = -radius; dy <= radius; ++dy) {
                            for (int dz = -radius; dz <= radius; ++dz) {
                                int iSouth;
                                int iNorth;
                                int iUp;
                                int iDown;
                                int iEast;
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] != j - 1) continue;
                                int iWest = (dx + halfLength - 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength);
                                if (this.adjacentTreeBlocks[iWest] == -2) {
                                    this.adjacentTreeBlocks[iWest] = j;
                                }
                                if (this.adjacentTreeBlocks[iEast = (dx + halfLength + 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[iEast] = j;
                                }
                                if (this.adjacentTreeBlocks[iDown = (dx + halfLength) * xSpan + (dy + halfLength - 1) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[iDown] = j;
                                }
                                if (this.adjacentTreeBlocks[iUp = (dx + halfLength) * xSpan + (dy + halfLength + 1) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[iUp] = j;
                                }
                                if (this.adjacentTreeBlocks[iNorth = (dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength - 1)] == -2) {
                                    this.adjacentTreeBlocks[iNorth] = j;
                                }
                                if (this.adjacentTreeBlocks[iSouth = (dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength + 1)] != -2) continue;
                                this.adjacentTreeBlocks[iSouth] = j;
                            }
                        }
                    }
                }
            }
            if (this.adjacentTreeBlocks[halfLength * xSpan + halfLength * ySpan + halfLength] >= 0) {
                world.setBlockData(tilePos, BlockLogicLeavesBase.setDecaying(meta, false));
            } else {
                this.removeLeaves(world, tilePos);
            }
        }
    }

    private void removeLeaves(@NotNull World world, @NotNull TilePosc tilePos) {
        this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
        world.setBlockTypeNotify(tilePos, Blocks.AIR);
    }

    public static boolean isPermanent(int meta) {
        return (meta & 1) != 0;
    }

    public static int setPermanent(int meta, boolean permanent) {
        if (permanent) {
            return meta | 1;
        }
        return meta & 0xFFFFFFFE;
    }

    public static boolean isDecaying(int meta) {
        return (meta & 8) != 0;
    }

    public static int setDecaying(int meta, boolean decaying) {
        if (decaying) {
            return meta | 8;
        }
        return meta & 0xFFFFFFF7;
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return 1;
    }

    @Override
    public float getAmbientOcclusionStrength(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return enableTreeShadowing ? 0.8f : 0.0f;
    }

    @Override
    public boolean isEquivalent(@NotNull World world, @NotNull TilePosc thisPos, @NotNull TilePosc thatPos) {
        Block<?> bBlock = world.getBlockType(thatPos);
        int thisMeta = world.getBlockData(thisPos) & 0xFFFFFFF0;
        int otherMeta = world.getBlockData(thatPos) & 0xFFFFFFF0;
        return this.block == bBlock && thisMeta == otherMeta;
    }
}

