/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.entity.mojang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.collection.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.dragonfly.data.entity.EntityModelData;
import org.useless.dragonfly.data.entity.mojang.Bone;
import org.useless.dragonfly.data.entity.mojang.Cube;
import org.useless.dragonfly.data.entity.mojang.Face;
import org.useless.dragonfly.models.entity.StaticEntityModel;
import org.useless.dragonfly.models.entity.mojang.StaticEntityModelMojang;
import org.useless.util.GsonHelper;

public class EntityGeometryMojangData
implements EntityModelData {
    @NotNull
    public static final String CURRENT_VERSION = "1.8.0";
    public static final int DEFAULT_TEX_WIDTH = 64;
    public static final int DEFAULT_TEX_HEIGHT = 32;
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static final Gson gson = EntityGeometryMojangData.builder().create();
    @NotNull
    protected final String modelId;
    @NotNull
    public final String version;
    public final double vBoundsWidth;
    public final double vBoundsHeight;
    public final double @NotNull [] vBoundsOffset;
    public final int textureWidth;
    public final int textureHeight;
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull Bone> bones;

    protected static GsonBuilder builder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)Builder.class), new Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Bone.Builder.class), new Bone.Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Cube.Builder.class), new Cube.Builder.Serializer());
        builder.registerTypeAdapter((Type)((Object)Face.Builder.class), new Face.Builder.Serializer());
        return builder;
    }

    protected EntityGeometryMojangData(@NotNull String modelId, @NotNull String version, double vBoundsWidth, double vBoundsHeight, double @NotNull [] vBoundsOffset, int textureWidth, int textureHeight, @NotNull @NotNull Iterable<@NotNull Bone.Builder> bones) {
        this.modelId = modelId;
        this.version = version;
        this.vBoundsWidth = vBoundsWidth;
        this.vBoundsHeight = vBoundsHeight;
        this.vBoundsOffset = vBoundsOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.bones = new LinkedHashMap<String, Bone>();
        for (Bone.Builder builder : bones) {
            @NotNull Bone bone = builder.build();
            this.bones.put(bone.name, bone);
        }
    }

    @Override
    @NotNull
    public String modelId() {
        return this.modelId;
    }

    @Override
    @NotNull
    public StaticEntityModel asModel(double inflation) {
        return new StaticEntityModelMojang(this, inflation);
    }

    public static class Builder {
        @NotNull
        private String version = "1.8.0";
        private final double vBoundsWidth;
        private final double vBoundsHeight;
        private final double @NotNull [] vBoundsOffset;
        private int texWidth;
        private int texHeight;
        @NotNull
        private final @NotNull List<@NotNull Bone.Builder> bones = new ArrayList<Bone.Builder>();

        public Builder(double visualBoundsWidth, double visualBoundsHeight) {
            this.vBoundsWidth = visualBoundsWidth;
            this.vBoundsHeight = visualBoundsHeight;
            this.vBoundsOffset = new double[]{0.0, 0.0, 0.0};
            this.texWidth = 64;
            this.texHeight = 32;
        }

        @NotNull
        public Builder setVersion(@NotNull String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public Builder setVisualBoundsOffset(double offX, double offY, double offZ) {
            this.vBoundsOffset[0] = offX;
            this.vBoundsOffset[1] = offY;
            this.vBoundsOffset[2] = offZ;
            return this;
        }

        @NotNull
        public Builder setTextureSize(int texWidth, int texHeight) {
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            return this;
        }

        @NotNull
        public Builder addBone(@NotNull Bone.Builder boneBuilder) {
            this.bones.add(boneBuilder);
            return this;
        }

        public EntityGeometryMojangData build(@NotNull String modelID) {
            return new EntityGeometryMojangData(modelID, this.version, this.vBoundsWidth, this.vBoundsHeight, this.vBoundsOffset, this.texWidth, this.texHeight, this.bones);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Builder builder;
                JsonObject object = json.getAsJsonObject();
                if (object.has("description")) {
                    JsonObject description = object.getAsJsonObject("description");
                    builder = new Builder(description.get("visible_bounds_width").getAsDouble(), description.get("visible_bounds_height").getAsDouble());
                    if (description.has("visible_bounds_offset")) {
                        double[] offset = GsonHelper.getAsDoubleArray(description.get("visible_bounds_offset"), 3);
                        builder.setVisualBoundsOffset(offset[0], offset[1], offset[2]);
                    }
                    if (description.has("texture_width") && description.has("texture_height")) {
                        int width = description.get("texture_width").getAsInt();
                        int height = description.get("texture_height").getAsInt();
                        builder.setTextureSize(width, height);
                    }
                } else {
                    builder = new Builder(object.get("visible_bounds_width").getAsDouble(), object.get("visible_bounds_height").getAsDouble());
                    if (object.has("visible_bounds_offset")) {
                        double[] offset = GsonHelper.getAsDoubleArray(object.get("visible_bounds_offset"), 3);
                        builder.setVisualBoundsOffset(offset[0], offset[1], offset[2]);
                    }
                    if (object.has("texturewidth") && object.has("textureheight")) {
                        int width = object.get("texturewidth").getAsInt();
                        int height = object.get("textureheight").getAsInt();
                        builder.setTextureSize(width, height);
                    }
                }
                if (object.has("bones")) {
                    JsonArray bones = object.getAsJsonArray("bones");
                    for (JsonElement e : bones) {
                        builder.addBone((Bone.Builder)context.deserialize(e, (Type)((Object)Bone.Builder.class)));
                    }
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class Cache {
        protected static final Map<String, EntityGeometryMojangData> modelDataCache = new HashMap<String, EntityGeometryMojangData>();
        @NotNull
        protected static final @NotNull Map<@NotNull NamespaceID, @NotNull Map<@NotNull String, @NotNull Pair<String, Double>>> localModelMappings = new HashMap<NamespaceID, Map<String, Pair<String, Double>>>();

        @NotNull
        public static StaticEntityModel getFallbackModel() {
            return new Builder(1.0, 1.0).addBone(new Bone.Builder("cube").addCube(new Cube.Builder(-8.0, 0.0, -8.0, 16.0, 16.0, 16.0).setFaces(0.0, 0.0))).build("geometry.missing").asModel(0.0);
        }

        @NotNull
        public static StaticEntityModel getModel(@NotNull String id, double inflation) {
            EntityGeometryMojangData data = Cache.getGeometry(id);
            if (data == null) {
                LOGGER.error("No model data for model '{}'!", (Object)id);
                return Cache.getFallbackModel();
            }
            return data.asModel(inflation);
        }

        @NotNull
        public static StaticEntityModel getModelForEntity(@NotNull NamespaceID namespaceID, @NotNull String localModelId) {
            if (localModelMappings.containsKey(namespaceID)) {
                Map<String, Pair<String, Double>> modelMap = localModelMappings.get(namespaceID);
                Pair<String, Double> pair = modelMap.get(localModelId);
                if (pair == null) {
                    return Cache.getFallbackModel();
                }
                return Cache.getModel(pair.getLeft(), pair.getRight());
            }
            return Cache.getFallbackModel();
        }

        @Nullable
        public static EntityGeometryMojangData getGeometry(@NotNull String id) {
            return modelDataCache.get(id);
        }

        public static void loadModelsFromResource(@NotNull InputStream stream) {
            JsonObject modelData = JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject();
            String version = modelData.get("format_version").getAsString();
            if (modelData.has("minecraft:geometry")) {
                JsonArray geometries = modelData.getAsJsonArray("minecraft:geometry");
                for (JsonElement e : geometries) {
                    JsonObject object = e.getAsJsonObject();
                    String id = object.getAsJsonObject("description").get("identifier").getAsString();
                    try {
                        EntityGeometryMojangData data = gson.fromJson(e, Builder.class).build(id);
                        modelDataCache.put(data.modelId(), data);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Failed to load json data with key {} as geometry data!", (Object)id, (Object)ex);
                    }
                }
            } else {
                for (Map.Entry<String, JsonElement> entry : modelData.entrySet()) {
                    if ("format_version".equals(entry.getKey())) continue;
                    String id = entry.getKey();
                    try {
                        EntityGeometryMojangData data = gson.fromJson(entry.getValue(), Builder.class).build(id);
                        modelDataCache.put(data.modelId(), data);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to load json data with key {} as geometry data!", (Object)entry.getKey(), (Object)e);
                    }
                }
            }
        }

        public static void reload(@NotNull TexturePackList packList) {
            modelDataCache.clear();
            ArrayList<TexturePack> packs = new ArrayList<TexturePack>();
            packs.add(packList.getDefaultTexturePack());
            packs.addAll(packList.selectedPacks);
            HashSet<String> modelPaths = new HashSet<String>();
            for (TexturePack pack : packs) {
                try {
                    @Nullable InputStream stream = pack.getResourceAsStream("/assets/minecraft/models/entity/models.json");
                    try {
                        if (stream == null) continue;
                        JsonObject manifestObject = JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject();
                        if (manifestObject.has("model_paths")) {
                            JsonArray paths = manifestObject.getAsJsonArray("model_paths");
                            for (JsonElement jsonElement : paths) {
                                modelPaths.add(jsonElement.getAsString());
                            }
                        }
                        if (!manifestObject.has("renderers")) continue;
                        JsonObject renderersObj = manifestObject.getAsJsonObject("renderers");
                        for (Map.Entry entry : renderersObj.entrySet()) {
                            NamespaceID id;
                            try {
                                id = (NamespaceID)NamespaceID.fromPool((String)entry.getKey()).copyUnpooled();
                            }
                            catch (HardIllegalArgumentException exception) {
                                LOGGER.error("Id '{}' is malformed!", entry.getKey(), (Object)exception);
                                continue;
                            }
                            localModelMappings.putIfAbsent(id, new HashMap());
                            Map<String, Pair<String, Double>> modelMappings = localModelMappings.get(id);
                            JsonObject mappingsObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                            for (Map.Entry<String, JsonElement> mappingEntry : mappingsObject.entrySet()) {
                                JsonElement element = mappingEntry.getValue();
                                if (element.isJsonPrimitive()) {
                                    modelMappings.put(mappingEntry.getKey(), Pair.of(mappingEntry.getValue().getAsString(), 0.0));
                                    continue;
                                }
                                if (element.isJsonObject()) {
                                    JsonObject mapping = element.getAsJsonObject();
                                    modelMappings.put(mappingEntry.getKey(), Pair.of(mapping.get("model").getAsString(), mapping.has("inflation") ? mapping.get("inflation").getAsDouble() : 0.0));
                                    continue;
                                }
                                LOGGER.warn("Unknown format for element '{}' of key '{}' in pack '{}'", element, mappingEntry.getKey(), pack.packId);
                            }
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception while reading entity models manifest in pack '{}'!", (Object)pack.packId, (Object)e);
                }
            }
            for (TexturePack pack : packs) {
                for (String s : modelPaths) {
                    try {
                        @Nullable InputStream stream = pack.getResourceAsStream(s);
                        try {
                            if (stream == null) continue;
                            Cache.loadModelsFromResource(stream);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to load data for resource at {}!", (Object)s, (Object)e);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error occurred when reading load data for resource at {}!", (Object)s, (Object)e);
                    }
                }
            }
        }
    }
}

