#version 410 core
// Only guranteed 16 4 comp locations, so some attributes are packed together to save count, see (https://docs.gl/gl4/glGet @ GL_MAX_VERTEX_ATTRIBS)
// Can combine uv and light shade in future if number needs further reduction
layout (location = 0) in vec3 aSourcePos;
layout (location = 1) in vec3 aSourceColor;
layout (location = 2) in vec3 aSourceNormal;

// Vertex one uses the position of the source pos
layout (location = 3) in vec2 aV1UV;
layout (location = 4) in vec2 aV1LightShade;

layout (location = 5) in vec3 aV2PosOffset;
layout (location = 6) in vec2 aV2UV;
layout (location = 7) in vec2 aV2LightShade;

layout (location = 8) in vec3 aV3PosOffset;
layout (location = 9) in vec2 aV3UV;
layout (location = 10) in vec2 aV3LightShade;

layout (location = 11) in vec3 aV4PosOffset;
layout (location = 12) in vec2 aV4UV;
layout (location = 13) in vec2 aV4LightShade;

out VS_OUT {
    vec3 sourcePos;
    vec3 sourceColor;
    vec3 sourceNormal;

    vec2 V1UV;
    vec2 V1LightShade;

    vec3 V2PosOffset;
    vec2 V2UV;
    vec2 V2LightShade;

    vec3 V3PosOffset;
    vec2 V3UV;
    vec2 V3LightShade;

    vec3 V4PosOffset;
    vec2 V4UV;
    vec2 V4LightShade;
} vs_out;

void main() {
    vs_out.sourcePos = aSourcePos;
    vs_out.sourceColor = aSourceColor;
    vs_out.sourceNormal = aSourceNormal;

    vs_out.V1UV = aV1UV;
    vs_out.V1LightShade = aV1LightShade;

    vs_out.V2PosOffset = aV2PosOffset;
    vs_out.V2UV = aV2UV;
    vs_out.V2LightShade = aV2LightShade;

    vs_out.V3PosOffset = aV3PosOffset;
    vs_out.V3UV = aV3UV;
    vs_out.V3LightShade = aV3LightShade;

    vs_out.V4PosOffset = aV4PosOffset;
    vs_out.V4UV = aV4UV;
    vs_out.V4LightShade = aV4LightShade;
}
