/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public abstract class BlockModel<T extends BlockLogic> {
    public static final float[] SIDE_LIGHT_MULTIPLIER = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public static final float FULL_CUBE_THRESHOLD = 0.0625f;
    public final Block<T> block;

    public BlockModel(Block<T> block) {
        this.block = block;
    }

    public abstract boolean render(@NotNull TessellatorGeneral var1, @NotNull WorldSource var2, @NotNull TilePosc var3);

    public abstract boolean renderNoCulling(@NotNull TessellatorGeneral var1, @NotNull WorldSource var2, @NotNull TilePosc var3);

    public abstract boolean renderWithOverrideTexture(@NotNull TessellatorGeneral var1, @NotNull WorldSource var2, @NotNull TilePosc var3, IconCoordinate var4);

    public abstract void renderStandalone(@NotNull TessellatorGeneral var1, int var2, byte var3);

    public abstract boolean shouldItemRender3d();

    @NotNull
    public abstract DisplayPos getItemDisplayPos(@NotNull String var1);

    public int renderLayer() {
        return 0;
    }

    @Nullable
    public abstract IconCoordinate getParticleTexture(@NotNull Side var1, int var2);

    @Nullable
    public abstract IconCoordinate getOverlayTexture(int var1);

    public abstract int particleColorIndex(@NotNull WorldSource var1, @NotNull TilePosc var2, @NotNull Side var3, int var4);

    public void onWorldChanged(@NotNull World world) {
    }

    public boolean isRetro() {
        return Minecraft.getMinecraft().currentWorld != null && Minecraft.getMinecraft().currentWorld.isRetro();
    }
}

