/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFluidStill
extends BlockLogicFluid {
    @NotNull
    public final Block<?> blockFlowing;

    public BlockLogicFluidStill(@NotNull Block<?> block, @NotNull Material material, @NotNull Fluid fluid, @NotNull Block<?> blockFlowing) {
        super(block, material, fluid);
        block.setTicking(this.fluid.shouldTick());
        this.blockFlowing = blockFlowing;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        super.onNeighborChanged(world, tilePos, block);
        if (world.getBlockType(tilePos) == this.block) {
            this.setFlowing(world, tilePos);
        }
    }

    private void setFlowing(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        world.noNeighborUpdate = true;
        world.setBlockTypeData(tilePos, this.blockFlowing, meta);
        world.markBlocksDirty(tilePos, tilePos);
        world.scheduleBlockUpdate(tilePos, this.blockFlowing, this.tickDelay());
        world.noNeighborUpdate = false;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.fluid.updateTickStill(this, world, tilePos, rand);
    }
}

