/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;

public class EntityLightning
extends Entity {
    private int life;
    public long seed = 0L;
    private int flashes;

    public EntityLightning(World world) {
        this(world, 0.0, 0.0, 0.0);
    }

    public EntityLightning(World world, double x, double y, double z) {
        super(world);
        this.moveTo(x, y, z, 0.0f, 0.0f);
        this.life = 2;
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    @Override
    public void tick() {
        int i;
        super.tick();
        if (this.life == 2) {
            this.world.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, this.x, this.y, this.z, "ambient.weather.thunder", 10000.0f, 0.8f + this.random.nextFloat() * 0.2f);
            this.world.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, this.x, this.y, this.z, "random.explode", 2.0f, 0.5f + this.random.nextFloat() * 0.2f);
            for (i = 0; i < this.world.entities.size(); ++i) {
                Entity e = this.world.entities.get(i);
                if (!(e instanceof MobWolf)) continue;
                ((MobWolf)e).whine();
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.remove();
            } else if (this.life < -this.random.nextInt(10)) {
                int k;
                int j;
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                if (this.world.areBlocksLoaded(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z), 10) && this.world.getBlockId(i = MathHelper.floor(this.x), j = MathHelper.floor(this.y), k = MathHelper.floor(this.z)) == 0 && Blocks.FIRE.canPlaceBlockAt(this.world, i, j, k)) {
                    this.world.setBlockWithNotify(i, j, k, Blocks.FIRE.id());
                }
            }
        }
        if (this.life >= 0) {
            double radius = 3.0;
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, new AABBd(this.x - radius, this.y - radius, this.z - radius, this.x + radius, this.y + 6.0 + radius, this.z + radius));
            for (Entity entity : list) {
                entity.thunderHit(this);
            }
            this.world.lightningFlicker = 2;
        }
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public void spawnInit() {
        if (this.world.getDifficulty().id() >= Difficulty.NORMAL.id() && this.world.areBlocksLoaded(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z), 10)) {
            int i1;
            int k;
            int i = MathHelper.floor(this.x);
            if (this.world.getBlockId(i, k = MathHelper.floor(this.y), i1 = MathHelper.floor(this.z)) == 0 && Blocks.FIRE.canPlaceBlockAt(this.world, i, k, i1)) {
                this.world.setBlockWithNotify(i, k, i1, Blocks.FIRE.id());
            }
            for (int j = 0; j < 4; ++j) {
                int k1;
                int j1;
                int l = MathHelper.floor(this.x) + this.random.nextInt(3) - 1;
                if (this.world.getBlockId(l, j1 = MathHelper.floor(this.y) + this.random.nextInt(3) - 1, k1 = MathHelper.floor(this.z) + this.random.nextInt(3) - 1) != 0 || !Blocks.FIRE.canPlaceBlockAt(this.world, l, j1, k1)) continue;
                this.world.setBlockWithNotify(l, j1, k1, Blocks.FIRE.id());
            }
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    @Override
    public boolean shouldRender(@NotNull Vector3dc cameraPos, double viewDistanceModifier) {
        return this.life >= 0;
    }
}

