/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.MapItemRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class ItemModelMap
extends ItemModelStandard {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final MapItemRenderer renderMapInstance = new MapItemRenderer();

    public ItemModelMap(Item item, String namespace) {
        super(item, namespace);
    }

    @Override
    public void renderFirstPerson(@NotNull TessellatorGeneral tessellator, @NotNull ItemRenderer itemRenderer, @NotNull Player player, @NotNull ItemStack itemStack, byte lightIndex, float partialTick) {
        if (ItemMap.hasInitialized(itemStack)) {
            GLRenderer.pushFrame();
            float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
            float swingProgress = player.getSwingProgress(partialTick);
            float f_z = MathHelper.sin(swingProgress * (float)java.lang.Math.PI);
            float f_x = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
            GLRenderer.modelM4f().translate(-f_x * 0.4f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * 2.0f) * 0.2f, -f_z * 0.2f);
            float f_val = MathHelper.clamp(1.0f - rotationPitch / 45.0f + 0.1f, 0.0f, 1.0f);
            f_val = -MathHelper.cos(f_val * (float)java.lang.Math.PI) * 0.5f + 0.5f;
            float zOff = -0.71999997f;
            GLRenderer.modelM4f().translate(0.0f, -(1.0f - itemRenderer.getEquippedProgress(partialTick)) * 1.2f - f_val * 0.5f + 0.04f, -0.71999997f);
            GLRenderer.modelM4f().rotateY(1.5707964f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(f_val * -85.0f));
            this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), this.mc.thePlayer.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
            MobRendererPlayer playerRenderer = (MobRendererPlayer)EntityRendererDispatcher.instance.getRenderer(this.mc.thePlayer);
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate(-0.0f, -0.6f, -1.1f);
            GLRenderer.modelM4f().rotateY((float)java.lang.Math.PI);
            GLRenderer.modelM4f().rotateX(-0.7853982f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(31.0f));
            GLRenderer.modelM4f().rotateY(Math.toRadians(65.0f));
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
            GLRenderer.modelM4f().translate(0.0f, 16.0f, 0.0f);
            GLRenderer.modelM4f().rotateX((float)java.lang.Math.PI);
            GLRenderer.modelM4f().translate(0.0f, -16.0f, 0.0f);
            GLRenderer.modelM4f().translate(0.0f, 8.0f, 0.0f);
            playerRenderer.drawFirstPersonHand(GLRenderer.getTessellator(), this.mc.thePlayer, true);
            GLRenderer.popFrame();
            GLRenderer.popFrame();
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate(-0.0f, -0.6f, 1.1f);
            GLRenderer.modelM4f().rotateX(-0.7853982f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(-31.0f));
            GLRenderer.modelM4f().rotateY(Math.toRadians(-65.0f));
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
            GLRenderer.modelM4f().translate(0.0f, 16.0f, 0.0f);
            GLRenderer.modelM4f().rotateX((float)java.lang.Math.PI);
            GLRenderer.modelM4f().translate(0.0f, -16.0f, 0.0f);
            GLRenderer.modelM4f().translate(0.0f, 8.0f, 0.0f);
            playerRenderer.drawFirstPersonHand(GLRenderer.getTessellator(), this.mc.thePlayer, false);
            GLRenderer.popFrame();
            GLRenderer.popFrame();
            float f_val3 = MathHelper.sin(swingProgress * swingProgress * (float)java.lang.Math.PI);
            float f_val4 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
            GLRenderer.modelM4f().rotateY(Math.toRadians(-f_val3 * 20.0f));
            GLRenderer.modelM4f().rotateZ(Math.toRadians(-f_val4 * 20.0f));
            GLRenderer.modelM4f().rotateX(Math.toRadians(-f_val4 * 80.0f));
            float scale1 = 0.38f;
            GLRenderer.modelM4f().scale(0.38f, 0.38f, 0.38f);
            GLRenderer.modelM4f().rotateY(1.5707964f);
            GLRenderer.modelM4f().rotateZ((float)java.lang.Math.PI);
            GLRenderer.modelM4f().translate(-1.0f, -1.0f, 0.0f);
            float scale2 = 0.015625f;
            GLRenderer.modelM4f().scale(0.015625f, 0.015625f, 0.015625f);
            this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/mapbg.png"));
            tessellator.startDrawingQuads();
            int expansion = 7;
            tessellator.addVertexWithUV(-7.0, 135.0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(135.0, 135.0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(135.0, -7.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(-7.0, -7.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            ItemMapSavedData mapData = Items.MAP.getOrCreateSavedData(itemStack, this.mc.currentWorld);
            if (mapData != null) {
                this.renderMapInstance.renderMap(tessellator, mapData);
            }
            GLRenderer.popFrame();
        } else {
            super.renderFirstPerson(tessellator, itemRenderer, player, itemStack, lightIndex, partialTick);
        }
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        if (!ItemMap.hasInitialized(itemStack)) {
            return TextureRegistry.getTexture("minecraft:item/map_blank");
        }
        return super.getIcon(entity, itemStack);
    }
}

