/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.Tessellator;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.slf4j.Logger;

public abstract class TessellatorBase
implements Tessellator {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public final String name;
    @NotNull
    public ByteBuffer data;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    @NotNull
    public DrawMode drawMode = DrawMode.TRIANGLES;
    public boolean drawing;
    public int vertexCount;

    public TessellatorBase(@NotNull String name, int initialCapacity) {
        this.name = name;
        this.data = BufferUtils.createByteBuffer(initialCapacity);
    }

    @Override
    public void startDrawing(@NotNull DrawMode drawMode) {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException(this.name + "Already drawing!");
        }
        this.drawMode = drawMode;
        this.drawing = true;
        this.vertexCount = 0;
        this.data.clear();
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
    }

    public void checkCanFit(int size) {
        if (this.data.capacity() < this.data.position() + size) {
            int newSize = this.data.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", this.name, this.data.capacity(), newSize);
            ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.data.flip();
            newBuffer.put(this.data);
            this.data = newBuffer;
        }
    }

    @Override
    public abstract void draw();

    @Override
    @NotNull
    public abstract RenderBuffer record(int var1, int var2);
}

