/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLogicFurnace
extends BlockLogicRotatable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean keepFurnaceInventory = false;
    protected final boolean isActive;

    public BlockLogicFurnace(Block<?> block, boolean active) {
        super(block, Materials.STONE);
        this.isActive = active;
        block.withEntity(TileEntityFurnace::new);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: 
            case PISTON_CRUSH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Blocks.FURNACE_STONE_IDLE);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isActive) {
            return;
        }
        double poxX = (double)tilePos.x() + 0.5;
        double posY = (double)tilePos.y() + 0.0 + (double)(rand.nextFloat() * 6.0f / 16.0f);
        double posZ = (double)tilePos.z() + 0.5;
        double f3 = 0.52f;
        double f4 = rand.nextFloat() * 0.6f - 0.3f;
        switch (BlockLogicRotatable.getDirectionFromMeta(world.getBlockData(tilePos))) {
            case WEST: {
                world.spawnParticle("smoke", poxX - f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", poxX - f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case EAST: {
                world.spawnParticle("smoke", poxX + f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", poxX + f3, posY, posZ + f4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case NORTH: {
                world.spawnParticle("smoke", poxX + f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", poxX + f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
                break;
            }
            case SOUTH: {
                world.spawnParticle("smoke", poxX + f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", poxX + f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
            }
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntity tileEntity;
        if (!world.isClientSide && (tileEntity = world.getTileEntity(tilePos)) instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)tileEntity;
            player.displayFurnaceScreen(furnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(@NotNull World world, @NotNull TilePos tilePos, boolean lit) {
        int meta = world.getBlockData(tilePos);
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity == null) {
            String msg = "Furnace is missing Tile Entity at " + String.valueOf(tilePos) + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
            LOGGER.warn(msg);
            return;
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockTypeNotify(tilePos, Blocks.FURNACE_STONE_ACTIVE);
        } else {
            world.setBlockTypeNotify(tilePos, Blocks.FURNACE_STONE_IDLE);
        }
        keepFurnaceInventory = false;
        world.setBlockDataNotify(tilePos, meta);
        tileEntity.validate();
        world.setTileEntity(tilePos, tileEntity);
    }
}

