/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicLever
extends BlockLogic
implements ISupportable {
    public static final int MASK_POWERED = 16;
    public static final int MASK_ROTATION = 15;
    public static final int ROTATION_EAST = 1;
    public static final int ROTATION_WEST = 2;
    public static final int ROTATION_SOUTH = 3;
    public static final int ROTATION_NORTH = 4;
    public static final int ROTATION_TOP_NS = 5;
    public static final int ROTATION_TOP_WE = 6;
    public static final int ROTATION_BOTTOM_NS = 7;
    public static final int ROTATION_BOTTOM_WE = 8;

    public BlockLogicLever(@NotNull Block<?> block) {
        super(block, Materials.DECORATION);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        Side checkSide = side.getOpposite();
        return this.isSupported(world, tilePos, checkSide);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM) || this.isSupported(world, tilePos, Side.TOP) || this.isSupported(world, tilePos, Side.NORTH) || this.isSupported(world, tilePos, Side.SOUTH) || this.isSupported(world, tilePos, Side.WEST) || this.isSupported(world, tilePos, Side.EAST);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        boolean isPowered = BlockLogicLever.isPowered(meta);
        int rotation = -1;
        switch (side) {
            case BOTTOM: {
                if (!this.isSupported(world, tilePos, Side.TOP)) break;
                rotation = 7 + (mob.getHorizontalPlacementDirection(side).getAxis() == Axis.Z ? 1 : 0);
                break;
            }
            case TOP: {
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) break;
                rotation = 5 + (mob.getHorizontalPlacementDirection(side).getAxis() == Axis.Z ? 1 : 0);
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, tilePos, Side.SOUTH)) break;
                rotation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, tilePos, Side.NORTH)) break;
                rotation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, tilePos, Side.EAST)) break;
                rotation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, tilePos, Side.WEST)) break;
                rotation = 1;
            }
        }
        if (rotation == -1) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        } else {
            world.setBlockDataNotify(tilePos, rotation | (isPowered ? 16 : 0));
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        boolean isPowered = BlockLogicLever.isPowered(meta);
        int rotation = -1;
        switch (side.getOpposite()) {
            case BOTTOM: {
                if (!this.isSupported(world, tilePos, Side.TOP)) break;
                rotation = 7;
                break;
            }
            case TOP: {
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) break;
                rotation = 5;
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, tilePos, Side.SOUTH)) break;
                rotation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, tilePos, Side.NORTH)) break;
                rotation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, tilePos, Side.EAST)) break;
                rotation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, tilePos, Side.WEST)) break;
                rotation = 1;
            }
        }
        if (rotation == -1) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        } else {
            world.setBlockDataNotify(tilePos, rotation | (isPowered ? 16 : 0));
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (this.checkIfAttachedToBlock(world, tilePos)) {
            boolean shouldBreak;
            int rotation = BlockLogicLever.getRotation(world.getBlockData(tilePos));
            switch (rotation) {
                case 1: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.WEST)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.EAST)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.NORTH)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.SOUTH)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: 
                case 6: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.BOTTOM)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 7: 
                case 8: {
                    boolean bl;
                    if (!this.isSupported(world, tilePos, Side.TOP)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = shouldBreak = false;
                }
            }
            if (shouldBreak) {
                this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
            }
        }
    }

    private boolean checkIfAttachedToBlock(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.canPlaceAt(world, tilePos)) {
            return true;
        }
        this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
        world.setBlockTypeNotify(tilePos, Blocks.AIR);
        return false;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int rotation = BlockLogicLever.getRotation(source.getBlockData(tilePos));
        float f = 0.1875f;
        float f1 = 0.25f;
        return switch (rotation) {
            case 1 -> new AABBd(0.0, 0.2f, 0.3125, 0.375, 0.8f, 0.6875);
            case 2 -> new AABBd(0.625, 0.2f, 0.3125, 1.0, 0.8f, 0.6875);
            case 3 -> new AABBd(0.3125, 0.2f, 0.0, 0.6875, 0.8f, 0.375);
            case 4 -> new AABBd(0.3125, 0.2f, 0.625, 0.6875, 0.8f, 1.0);
            case 5, 6 -> new AABBd(0.25, 0.0, 0.25, 0.75, 0.6f, 0.75);
            default -> new AABBd(0.25, 0.4, 0.25, 0.75, 1.0, 0.75);
        };
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onInteracted(world, tilePos, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        this.flip(world, tilePos, player);
        return true;
    }

    public void flip(@NotNull World world, @NotNull TilePosc tilePos, @Nullable Player player) {
        int meta = world.getBlockData(tilePos);
        int rotation = BlockLogicLever.getRotation(meta);
        if (BlockLogicLever.isPowered(meta)) {
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFEF);
        } else {
            world.setBlockDataNotify(tilePos, meta | 0x10);
        }
        world.markBlocksDirty(tilePos, tilePos);
        world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "random.click", 0.3f, BlockLogicLever.isPowered(meta) ? 0.5f : 0.6f);
        world.notifyBlocksOfNeighborChange(tilePos, this.block);
        TilePos queryPos = new TilePos();
        switch (rotation) {
            case 1: {
                world.notifyBlocksOfNeighborChange(tilePos.west(queryPos), this.block);
                break;
            }
            case 2: {
                world.notifyBlocksOfNeighborChange(tilePos.east(queryPos), this.block);
                break;
            }
            case 3: {
                world.notifyBlocksOfNeighborChange(tilePos.north(queryPos), this.block);
                break;
            }
            case 4: {
                world.notifyBlocksOfNeighborChange(tilePos.south(queryPos), this.block);
                break;
            }
            case 5: 
            case 6: {
                world.notifyBlocksOfNeighborChange(tilePos.down(queryPos), this.block);
                break;
            }
            default: {
                world.notifyBlocksOfNeighborChange(tilePos.up(queryPos), this.block);
            }
        }
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.flip(world, tilePos, null);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (BlockLogicLever.isPowered(data)) {
            world.notifyBlocksOfNeighborChange(tilePos, this.block);
            TilePos queryPos = new TilePos();
            int rotation = BlockLogicLever.getRotation(data);
            switch (rotation) {
                case 1: {
                    world.notifyBlocksOfNeighborChange(tilePos.west(queryPos), this.block);
                    break;
                }
                case 2: {
                    world.notifyBlocksOfNeighborChange(tilePos.east(queryPos), this.block);
                    break;
                }
                case 3: {
                    world.notifyBlocksOfNeighborChange(tilePos.north(queryPos), this.block);
                    break;
                }
                case 4: {
                    world.notifyBlocksOfNeighborChange(tilePos.south(queryPos), this.block);
                    break;
                }
                case 5: 
                case 6: {
                    world.notifyBlocksOfNeighborChange(tilePos.down(queryPos), this.block);
                    break;
                }
                default: {
                    world.notifyBlocksOfNeighborChange(tilePos.up(queryPos), this.block);
                }
            }
        }
        super.onRemoved(world, tilePos, data);
    }

    public static int getRotation(int meta) {
        return meta & 0xF;
    }

    public static boolean isPowered(int meta) {
        return (meta & 0x10) != 0;
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return BlockLogicLever.isPowered(source.getBlockData(tilePos));
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        if (!BlockLogicLever.isPowered(meta)) {
            return false;
        }
        int rotation = BlockLogicLever.getRotation(meta);
        if (rotation == 8 && side == Side.BOTTOM) {
            return true;
        }
        if (rotation == 7 && side == Side.BOTTOM) {
            return true;
        }
        if (rotation == 6 && side == Side.TOP) {
            return true;
        }
        if (rotation == 5 && side == Side.TOP) {
            return true;
        }
        if (rotation == 4 && side == Side.NORTH) {
            return true;
        }
        if (rotation == 3 && side == Side.SOUTH) {
            return true;
        }
        if (rotation == 2 && side == Side.WEST) {
            return true;
        }
        return rotation == 1 && side == Side.EAST;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE.center();
    }
}

