/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHandCannonLoaded
extends Item {
    public ItemHandCannonLoaded(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxDamage(100);
        this.maxStackSize = 1;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        world.playSoundAtEntity(player, player, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * -0.2f - 0.4f));
        if (!world.isClientSide) {
            selfStack.damageItem(1, player);
            world.entityJoinedWorld(new ProjectileCannonball(world, player));
            if (selfStack.stackSize <= 0) {
                return null;
            }
            return new ItemStack(Items.HANDCANNON_UNLOADED, 1, selfStack.getMetadata(), selfStack.getData());
        }
        return selfStack;
    }
}

