/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectilePebble;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class ItemPebble
extends Item
implements IDispensable {
    public ItemPebble(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        selfStack.consumeItem(player);
        world.playSoundAtEntity(player, player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new ProjectilePebble(world, player));
        }
        return selfStack;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        int newMeta;
        if (player == null) {
            return false;
        }
        @NotNull Block<?> block = world.getBlockType(blockPos);
        int meta = world.getBlockData(blockPos);
        if (block != Blocks.OVERLAY_PEBBLES && block.hasTag(BlockTags.PLACE_OVERWRITES)) {
            block = Blocks.AIR;
            meta = 0;
        }
        if (selfStack.stackSize <= 0) {
            return false;
        }
        if (blockPos.y() == world.getHeightBlocks() - 1 && Blocks.OVERLAY_PEBBLES.getMaterial().isSolid()) {
            return false;
        }
        if (block == Blocks.OVERLAY_PEBBLES && side == Side.TOP) {
            newMeta = meta + 1;
            if (!world.canPlaceOnSurfaceOfBlock(blockPos.down(new TilePos()))) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockTypeDataNotify(blockPos, Blocks.OVERLAY_PEBBLES, newMeta);
                world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
                selfStack.consumeItem(player);
                return true;
            }
        }
        if (block != Blocks.AIR) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
            block = world.getBlockType(blockPos);
            meta = world.getBlockData(blockPos);
        }
        if (block == Blocks.OVERLAY_PEBBLES) {
            newMeta = meta + 1;
            AABBd bbBox = new AABBd(blockPos.x(), blockPos.y(), blockPos.z(), (float)blockPos.x() + 1.0f, (float)blockPos.y() + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockPos.z() + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox) || !world.canPlaceOnSurfaceOfBlock(blockPos.down(new TilePos()))) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockTypeDataNotify(blockPos, Blocks.OVERLAY_PEBBLES, newMeta);
                world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
                selfStack.consumeItem(player);
                return true;
            }
        }
        if (world.canBlockIdBePlacedAt(Blocks.OVERLAY_PEBBLES.id(), blockPos, false, side) && world.canPlaceOnSurfaceOfBlock(blockPos.down(new TilePos())) && world.setBlockTypeNotify(blockPos, Blocks.OVERLAY_PEBBLES)) {
            Blocks.OVERLAY_PEBBLES.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        ProjectilePebble projectilePebble = new ProjectilePebble(world, (double)blockPos.x() + offX, (double)blockPos.y() + offY, (double)blockPos.z() + offZ);
        projectilePebble.setHeading((double)direction.getOffsetX() * 0.6, direction.getOffsetY() == 0 ? 0.1 : (double)direction.getOffsetY() * 0.6, (float)direction.getOffsetZ() * 0.6f, 1.1f, 6.0f);
        world.entityJoinedWorld(projectilePebble);
        --selfStack.stackSize;
    }

    @Override
    public void onDispensed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Random random, @NotNull Direction direction, double x, double y, double z) {
        ProjectilePebble projectilePebble = new ProjectilePebble(world, x, y, z);
        projectilePebble.setHeading(direction.getOffsetX(), (double)direction.getOffsetY() + 0.1, direction.getOffsetZ(), 1.1f, 6.0f);
        world.entityJoinedWorld(projectilePebble);
    }
}

