/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.container;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerCompound
implements Container {
    @NotNull
    private final String name;
    @NotNull
    private final @NotNull Container @NotNull [] containers;

    public ContainerCompound(@NotNull String name, Container ... containers) {
        this.name = name;
        this.containers = containers;
        if (this.containers.length == 0) {
            throw new IllegalArgumentException("Cannot create an empty compound!");
        }
    }

    @Override
    public int getContainerSize() {
        int sum = 0;
        for (Container container : this.containers) {
            sum += container.getContainerSize();
        }
        return sum;
    }

    @Override
    @NotNull
    public String getNameTranslationKey() {
        return this.name;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        int sum = 0;
        for (Container container : this.containers) {
            if (slot < sum + container.getContainerSize()) {
                return container.getItem(slot - sum);
            }
            sum += container.getContainerSize();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack removeItem(int slot, int takeAmount) {
        if (slot < 0) {
            return null;
        }
        int sum = 0;
        for (Container container : this.containers) {
            if (slot < sum + container.getContainerSize()) {
                return container.removeItem(slot - sum, takeAmount);
            }
            sum += container.getContainerSize();
        }
        return null;
    }

    @Override
    public void setItem(int slot, @Nullable ItemStack stack) {
        if (slot < 0) {
            return;
        }
        int sum = 0;
        for (Container container : this.containers) {
            if (slot < sum + container.getContainerSize()) {
                container.setItem(slot - sum, stack);
                break;
            }
            sum += container.getContainerSize();
        }
    }

    @Override
    public int getMaxStackSize() {
        return this.containers[0].getMaxStackSize();
    }

    @Override
    public void setChanged() {
        for (Container container : this.containers) {
            container.setChanged();
        }
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        boolean invalid = false;
        for (Container container : this.containers) {
            invalid |= !container.stillValid(player);
        }
        return !invalid;
    }

    @Override
    public void sort() {
        int i;
        @Nullable ItemStack @NotNull [] itemStacks = new ItemStack[this.getContainerSize()];
        for (i = 0; i < itemStacks.length; ++i) {
            itemStacks[i] = this.getItem(i);
        }
        InventorySorter.sortInventory(itemStacks);
        for (i = 0; i < itemStacks.length; ++i) {
            this.setItem(i, itemStacks[i]);
        }
    }
}

