/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.error;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.enums.EnumGPUVendor;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ScreenMissingJCE
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CONTINUE_LENGTH = 1500;
    protected ButtonElement backButton = null;
    protected ButtonElement continueButton = null;
    protected ButtonElement downloadButton = null;
    protected ButtonElement upgradeButton = null;
    protected boolean continueHeld = false;
    protected long clickStart = 0L;
    protected Screen continueToScreen;

    public ScreenMissingJCE(Screen parent, Screen continueToScreen) {
        super(parent);
        this.continueToScreen = continueToScreen;
    }

    @Override
    public void init() {
        I18n i = I18n.getInstance();
        this.buttons.clear();
        String downloadString = i.translateKey("gui.no_jce.button.download");
        String patchString = i.translateKey("gui.no_jce.button.upgrade");
        this.backButton = this.add(new ButtonElement(0, this.width / 2 - 102, this.height / 4 + 120 + 12, 100, 20, i.translateKey("gui.no_jce.button.back")));
        this.continueButton = this.add(new ButtonElement(1, this.width / 2 + 2, this.height / 4 + 120 + 12, 100, 20, i.translateKey("gui.no_jce.button.continue")));
        this.downloadButton = this.add(new ClickableLabelElement(2, this.width / 2 - 170, this.height / 4 - 60 + 60 + 64, downloadString, 8165866));
        this.upgradeButton = this.add(new ClickableLabelElement(3, this.width / 2 - 170, this.height / 4 - 60 + 60 + 77, patchString, 8165866));
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.displayScreen(this.getParentScreen());
        }
        if (button.id == 1) {
            this.continueHeld = true;
            this.clickStart = System.currentTimeMillis();
        }
        if (button.id == 2) {
            UrlHelper.openURL("https://adoptium.net/en-GB/temurin/releases/?version=8");
        }
        if (button.id == 3) {
            UrlHelper.openURL("https://www.oracle.com/java/technologies/javase-jce-all-downloads.html");
        }
    }

    @Override
    protected void buttonReleased(@NotNull ButtonElement button) {
        if (button.id == 1) {
            this.continueHeld = false;
            this.clickStart = 0L;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i = I18n.getInstance();
        this.renderBackground();
        this.drawStringCenteredShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.1"), this.width / 2 - 170, this.height / 4 - 60 + 60, 0xA0A0A0);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 18, 0xA0A0A0);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.4"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 45, 0xA0A0A0);
        this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.5"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 54, 0xA0A0A0);
        if (Minecraft.GPU_VENDOR == EnumGPUVendor.INTEL) {
            this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.intel.disclaimer.1"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 72, 0xA0A0A0);
            this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.intel.disclaimer.2"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 81, 0xA0A0A0);
            this.drawStringShadow(this.fontRenderer, i.translateKey("gui.no_jce.label.body.intel.disclaimer.3"), this.width / 2 - 170, this.height / 4 - 60 + 60 + 90, 0xA0A0A0);
            this.downloadButton.yPosition = this.height / 4 - 60 + 60 + 100;
            this.downloadButton.displayString = i.translateKey("gui.no_jce.button.download");
            this.upgradeButton.yPosition = this.height / 4 - 60 + 60 + 113;
            this.upgradeButton.displayString = i.translateKey("gui.no_jce.button.upgrade.recommended");
        } else {
            this.downloadButton.yPosition = this.height / 4 - 60 + 60 + 64;
            this.downloadButton.displayString = i.translateKey("gui.no_jce.button.download.recommended");
            this.upgradeButton.yPosition = this.height / 4 - 60 + 60 + 77;
            this.upgradeButton.displayString = i.translateKey("gui.no_jce.button.upgrade");
        }
        this.backButton.drawButton(this.mc, mx, my);
        this.continueButton.drawButton(this.mc, mx, my);
        this.downloadButton.drawButton(this.mc, mx, my);
        this.upgradeButton.drawButton(this.mc, mx, my);
        if (this.continueHeld) {
            long delta = System.currentTimeMillis() - this.clickStart;
            this.drawRectDouble(this.continueButton.xPosition, this.continueButton.yPosition, (float)this.continueButton.xPosition + (float)this.continueButton.width * ((float)delta / 1500.0f), this.continueButton.yPosition + this.continueButton.height, Color.intToIntARGB(127, 255, 255, 255));
            if (delta >= 1500L) {
                this.mc.displayScreen(this.continueToScreen);
            }
        }
    }
}

