/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.net.ServerAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerEntry {
    @NotNull
    public UUID uuid;
    @Nullable
    public String overrideName;
    @Nullable
    public String baseName;
    @Nullable
    public String motd;
    @NotNull
    public String address;
    @Nullable
    public ServerAddress addressResolved;
    @Nullable
    public Texture icon;
    @Nullable
    public BufferedImage queuedIcon;
    public int playerCount;
    public int playerCap;
    @NotNull
    public List<String> players = new ArrayList<String>();
    @Nullable
    public String version;
    public int protocolVersion = -1;
    public long ping;
    public long lastPlayedTime = -1L;
    public boolean isUp = false;
    public boolean showIp = false;
    public boolean requestIcon = false;
    public boolean dirty = false;

    public ServerEntry(@NotNull UUID uuid, @NotNull String address) {
        this.uuid = uuid;
        this.address = address;
        this.icon = ScreenSelectServer.defaultIcon;
    }

    @NotNull
    public String getName(@NotNull String defaultName) {
        if (this.overrideName != null && !this.overrideName.isBlank()) {
            return this.overrideName;
        }
        if (this.baseName != null && !this.baseName.isBlank()) {
            return this.baseName;
        }
        return defaultName;
    }

    public void free() {
        if (this.icon != null && this.icon != ScreenSelectServer.defaultIcon) {
            this.icon.delete();
            this.icon = null;
        }
    }

    @NotNull
    public ServerAddress getServerAddress() {
        if (this.addressResolved == null) {
            this.addressResolved = Objects.requireNonNull(ServerAddress.resolveServerIP(this.address));
        }
        return this.addressResolved;
    }
}

