/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import paulscode.sound.SoundSystem;

public class OptionVolume
extends OptionFloat {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public final SoundCategory soundCategory;

    public OptionVolume(@NotNull String name, float value, @NotNull SoundCategory soundCategory) {
        super(name, value);
        this.soundCategory = soundCategory;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        Minecraft.getMinecraft().sndManager.updateOptions();
        SoundSystem soundSystem = SoundEngine.getSoundSystem();
        try {
            if (soundSystem != null) {
                if (this.soundCategory != SoundCategory.GUI_SOUNDS && !soundSystem.playing("sound_audio_options")) {
                    Minecraft.getMinecraft().sndManager.playSoundWithID(this.soundCategory.changedSound, this.soundCategory, 1.0f, 1.0f, "sound_audio_options");
                } else if (this.soundCategory != SoundCategory.GUI_SOUNDS) {
                    soundSystem.setVolume("sound_audio_options", SoundCategoryHelper.getEffectiveVolume(this.soundCategory));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error occurred while trying to preview sounds! This is a poorly known issue please report!", e);
        }
    }
}

