/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import java.util.Random;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericAxis;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericMatcher<T extends BlockLogic>
extends BlockModelGenericAxis<T> {
    @NotNull
    public final StaticBlockModel[] models = new StaticBlockModel[4];
    public final Random random = new Random();

    public BlockModelGenericMatcher(@NotNull Block<T> block, @NotNull String baseKey) {
        super(block, BlockModelDispatcher.loadDataModel(baseKey + "0"));
        for (int i = 0; i < 4; ++i) {
            this.models[i] = BlockModelDispatcher.loadDataModel(baseKey + i).asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        this.random.setSeed(this.getPositionalSeed(tilePosc));
        return this.models[this.random.nextInt(4)];
    }

    public long getPositionalSeed(@NotNull TilePosc tilePos) {
        return (long)tilePos.x() * 374761393L + (long)tilePos.y() * 668265263L + (long)tilePos.z() * 968290493L;
    }
}

