/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.client.world.WorldClient;
import net.minecraft.client.world.chunk.provider.ChunkProviderClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.ChunkProvider;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.LevelStorageDummy;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldClientMP
extends WorldClient {
    private final LinkedList<WorldBlockPositionType> positionTypesList = new LinkedList();
    private final PacketHandlerClient sendQueue;
    private ChunkProviderClient chunkCache;
    private final Int2ObjectMap<Entity> entitiesById = new Int2ObjectOpenHashMap<Entity>();
    private final Set<Entity> forced = new HashSet<Entity>();
    private final Set<Entity> reEntries = new HashSet<Entity>();

    public WorldClientMP(@NotNull PacketHandlerClient packetHandler, @NotNull Minecraft mc, @NotNull WorldConfiguration worldConfiguration, @NotNull Dimension dimension) {
        super(mc, new LevelStorageDummy(), worldConfiguration, dimension);
        this.sendQueue = packetHandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    public void tick() {
        if (this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            this.getLevelData().setWorldTime(this.getLevelData().getWorldTime() + 1L);
        }
        for (int k = 0; k < 10 && !this.reEntries.isEmpty(); ++k) {
            Entity entity = this.reEntries.iterator().next();
            if (this.entities.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.processPackets();
        for (int l = 0; l < this.positionTypesList.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(l);
            if (--worldblockpositiontype.delayTicks != 0) continue;
            super.setBlockTypeData(worldblockpositiontype.blockPos, worldblockpositiontype.block, worldblockpositiontype.metadata);
            super.markBlockNeedsUpdate(worldblockpositiontype.blockPos);
            this.positionTypesList.remove(l--);
        }
        this.updateSeasonAndLight();
        if (this.rainbowTicks > 0) {
            --this.rainbowTicks;
        }
    }

    public void processPackets() {
        this.sendQueue.tick();
    }

    public void removePositionTypesInBounds(@NotNull TilePosc min, @NotNull TilePosc max) {
        for (int i = 0; i < this.positionTypesList.size(); ++i) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(i);
            if (worldblockpositiontype.blockPos.x() < min.x() || worldblockpositiontype.blockPos.y() < min.y() || worldblockpositiontype.blockPos.z() < min.z() || worldblockpositiontype.blockPos.x() > max.x() || worldblockpositiontype.blockPos.y() > max.y() || worldblockpositiontype.blockPos.z() > max.z()) continue;
            this.positionTypesList.remove(i--);
        }
    }

    @Override
    @NotNull
    protected ChunkProvider createChunkProvider(@NotNull LevelStorage levelStorage) {
        this.chunkCache = new ChunkProviderClient(this);
        return this.chunkCache;
    }

    @Override
    public void getRespawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(@NotNull TilePosc tilePos, @NotNull Block<?> block, long delay) {
    }

    @Override
    public boolean tickPendingTicks(boolean all) {
        return false;
    }

    public void doPreChunk(@NotNull ChunkPos chunkPos, boolean playerAdded) {
        if (playerAdded) {
            this.chunkCache.prepareChunk(chunkPos, true);
        } else {
            this.chunkCache.dropChunk(chunkPos);
        }
        if (!playerAdded) {
            this.markBlocksDirty(new TilePos(chunkPos.x() * 16, 0, chunkPos.z() * 16), new TilePos(chunkPos.x() * 16 + 15, this.getHeightBlocks(), chunkPos.z() * 16 + 15));
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.forced.add(entity);
        if (!flag) {
            this.reEntries.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.forced.remove(entity);
        this.reEntries.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        this.reEntries.remove(entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.forced.contains(entity)) {
            this.reEntries.add(entity);
        }
    }

    public void addEntityToWorld(int i, Entity entity) {
        Entity entity1 = this.getEntityFromId(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.forced.add(entity);
        entity.id = i;
        if (!this.entityJoinedWorld(entity)) {
            this.reEntries.add(entity);
        }
        this.entitiesById.put(i, entity);
    }

    public Entity getEntityFromId(int i) {
        return (Entity)this.entitiesById.get(i);
    }

    @Nullable
    public Entity removeEntityFromWorld(int i) {
        Entity entity = (Entity)this.entitiesById.remove(i);
        if (entity != null) {
            this.forced.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockData(@NotNull TilePosc tilePos, int data) {
        @NotNull Block<?> block = this.getBlockType(tilePos);
        int currentData = this.getBlockData(tilePos);
        if (super.setBlockData(tilePos, data)) {
            this.positionTypesList.add(new WorldBlockPositionType(tilePos, block, currentData));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockTypeData(@NotNull TilePosc tilePos, @NotNull Block<?> block, int data) {
        @NotNull Block<?> currentBlock = this.getBlockType(tilePos);
        int currentData = this.getBlockData(tilePos);
        if (super.setBlockTypeData(tilePos, block, data)) {
            this.positionTypesList.add(new WorldBlockPositionType(tilePos, currentBlock, currentData));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockType(@NotNull TilePosc tilePos, @NotNull Block<?> block) {
        @NotNull Block<?> currentBlock = this.getBlockType(tilePos);
        int currentData = this.getBlockData(tilePos);
        if (super.setBlockType(tilePos, block)) {
            this.positionTypesList.add(new WorldBlockPositionType(tilePos, currentBlock, currentData));
            return true;
        }
        return false;
    }

    public boolean blockChange(@NotNull TilePosc blockPos, @NotNull Block<?> block, int meta) {
        this.removePositionTypesInBounds(blockPos, blockPos);
        if (super.setBlockTypeData(blockPos, block, meta)) {
            this.notifyBlockChange(blockPos, block);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.sendFinalPacket(new PacketDisconnect("Quitting"));
    }

    @Override
    public void sendGlobalMessage(String message) {
    }

    static class WorldBlockPositionType {
        @NotNull
        final TilePosc blockPos;
        int delayTicks;
        @NotNull
        final Block<?> block;
        final int metadata;

        public WorldBlockPositionType(@NotNull TilePosc blockPos, @NotNull Block<?> block, int metadata) {
            this.blockPos = new TilePos(blockPos);
            this.delayTicks = 80;
            this.block = block;
            this.metadata = metadata;
        }
    }
}

