/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPistonHead
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;
    public static final int MASK_TYPE = 248;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STICKY = 1;
    public static final int TYPE_STEEL = 2;
    private final double headThickness;
    private final double shaftThickness;

    public BlockLogicPistonHead(Block<?> block, double headThickness, double shaftThickness) {
        super(block, Materials.PISTON);
        block.withHardness(0.5f);
        this.headThickness = headThickness;
        this.shaftThickness = shaftThickness;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        int data2;
        super.onRemoved(world, tilePos, data);
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(data);
        if (direction == Direction.NONE) {
            return;
        }
        Direction orientation = direction.getOpposite();
        TilePos nextPos = tilePos.add(orientation, new TilePos());
        Block<?> block = world.getBlockType(nextPos);
        if (block != null && block.getLogic() instanceof BlockLogicPistonBase && BlockLogicPistonBase.isPowered(data2 = world.getBlockData(nextPos))) {
            block.dropWithCause(world, EnumDropCause.PROPER_TOOL, nextPos, data2, null, null);
            world.setBlockTypeNotify(nextPos, Blocks.AIR);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        return BlockLogicPistonHead.getDirectionFromMeta(meta).getSide() == side ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return false;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return false;
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePosc tilePos, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        switch (BlockLogicPistonHead.getDirectionFromMeta(world.getBlockData(tilePos))) {
            case DOWN: {
                this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(0.5 - this.shaftThickness / 2.0, this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 + this.headThickness, 0.5 + this.shaftThickness / 2.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                break;
            }
            case UP: {
                this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(0.5 - this.shaftThickness / 2.0, -this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 - this.headThickness, 0.5 + this.shaftThickness / 2.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                break;
            }
            case NORTH: {
                this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 + this.headThickness).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                break;
            }
            case SOUTH: {
                this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, -this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 - this.headThickness).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                break;
            }
            case WEST: {
                this.addIntersectingBoundingBox(aabb, new AABBd(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, 1.0 + this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                break;
            }
            case EAST: {
                this.addIntersectingBoundingBox(aabb, new AABBd(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
                this.addIntersectingBoundingBox(aabb, new AABBd(-this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, 1.0 - this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0).translate(tilePos.x(), tilePos.y(), tilePos.z()), aabbList);
            }
        }
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return switch (BlockLogicPistonHead.getDirectionFromMeta(source.getBlockData(tilePos))) {
            case Direction.DOWN -> new AABBd(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0);
            case Direction.UP -> new AABBd(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0);
            case Direction.NORTH -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness);
            case Direction.SOUTH -> new AABBd(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0);
            case Direction.WEST -> new AABBd(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0);
            case Direction.EAST -> new AABBd(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            default -> super.getBoundsFromState(source, tilePos);
        };
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(world.getBlockData(tilePos));
        if (direction == Direction.NONE) {
            return;
        }
        TilePos posOffset = tilePos.sub(direction, new TilePos());
        Block<?> offsetBlock = world.getBlockType(posOffset);
        if (offsetBlock.getLogic() instanceof BlockLogicPistonBase) {
            offsetBlock.onNeighborChanged(world, posOffset, block);
        } else {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 2;
    }

    public static Direction getDirectionFromMeta(int meta) {
        return Direction.getDirectionById(meta & 7);
    }

    public static int getPistonType(int data) {
        return (data & 0xFF & 0xF8) >> 3;
    }

    public static int setPistonType(int type, int data) {
        return (data & 0xFFFFFF07 | type << 3) & 0xFF;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            ItemStack[] itemStackArray;
            switch (BlockLogicPistonHead.getPistonType(data)) {
                case 0: {
                    ItemStack[] itemStackArray2 = new ItemStack[1];
                    itemStackArray = itemStackArray2;
                    itemStackArray2[0] = new ItemStack(Blocks.PISTON_BASE);
                    break;
                }
                case 1: {
                    ItemStack[] itemStackArray3 = new ItemStack[1];
                    itemStackArray = itemStackArray3;
                    itemStackArray3[0] = new ItemStack(Blocks.PISTON_BASE_STICKY);
                    break;
                }
                case 2: {
                    ItemStack[] itemStackArray4 = new ItemStack[1];
                    itemStackArray = itemStackArray4;
                    itemStackArray4[0] = new ItemStack(Blocks.PISTON_BASE_STEEL);
                    break;
                }
                default: {
                    itemStackArray = null;
                }
            }
            return itemStackArray;
        }
        return null;
    }
}

