/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.client.gui.server.ServerListenerThread;
import net.minecraft.client.net.handler.PingPacketHandler;
import net.minecraft.core.net.ServerAddress;
import net.minecraft.core.net.packet.PacketPingHandshake;

public class ThreadPingServer
extends Thread {
    private final ServerListenerThread listenerThread;
    private final ServerEntry server;

    public ThreadPingServer(ServerListenerThread listenerThread, ServerEntry server) {
        this.listenerThread = listenerThread;
        this.server = server;
        this.setName("ThreadPingServer - " + server.address);
    }

    public ServerEntry getServer() {
        return this.server;
    }

    @Override
    public void run() {
        ServerAddress address = this.server.getServerAddress();
        String hostName = address.getIP();
        int port = address.getPort();
        try {
            PingPacketHandler netHandler = new PingPacketHandler(this.listenerThread, this.server);
            if (this.server.requestIcon) {
                netHandler.addToSendQueue(new PacketPingHandshake(3, 250, "BTAPingHost", 65312, hostName, port));
                this.server.requestIcon = false;
            } else {
                netHandler.addToSendQueue(new PacketPingHandshake(2, 250, "BTAPingHost", 65312, hostName, port));
            }
            while (!netHandler.disconnected) {
                netHandler.processReadPackets();
                Thread.sleep(1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

