/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericDoor<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel left;
    @NotNull
    public final StaticBlockModel left_open;
    @NotNull
    public final StaticBlockModel right;
    @NotNull
    public final StaticBlockModel right_open;

    public BlockModelGenericDoor(@NotNull Block<T> block, @NotNull String basekey, boolean bottom) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/" + (bottom ? "bottom" : "top") + "_left"));
        String side = bottom ? "bottom" : "top";
        this.left = BlockModelDispatcher.loadDataModel("%s/%s_left".formatted(basekey, side)).asModel();
        this.left_open = BlockModelDispatcher.loadDataModel("%s/%s_left_open".formatted(basekey, side)).asModel();
        this.right = BlockModelDispatcher.loadDataModel("%s/%s_right".formatted(basekey, side)).asModel();
        this.right_open = BlockModelDispatcher.loadDataModel("%s/%s_right_open".formatted(basekey, side)).asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean isOpen;
        int data = worldSource.getBlockData(tilePos);
        int rotation = data & 3;
        boolean bl = isOpen = (data & 4) != 0;
        if (isOpen) {
            return switch (rotation) {
                case 0 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
                case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
                case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
                default -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            };
        }
        return switch (rotation) {
            case 0 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            default -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        boolean isOpen;
        boolean isLeft = (data & 8) != 0;
        boolean bl = isOpen = (data & 4) != 0;
        if (isLeft) {
            return isOpen ? this.left_open : this.left;
        }
        return isOpen ? this.right : this.right_open;
    }
}

