/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.shader.framebuffer.FrameBuffer;
import net.minecraft.client.util.helper.FileOpener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL41;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class ScreenShot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static int transferPbo = -1;
    private static int pboWidth = -1;
    private static int pboHeight = -1;
    private static long fence = -1L;
    @Nullable
    private static File destFile = null;

    public static void saveScreenshot(Minecraft mc, File mcDir, int width, int height) {
        if (fence >= 0L) {
            return;
        }
        if (transferPbo < 0 || width != pboWidth || height != pboHeight) {
            pboWidth = width;
            pboHeight = height;
            if (transferPbo >= 0) {
                GL41.glDeleteBuffers(transferPbo);
            }
            transferPbo = GL41.glGenBuffers();
            GL41.glBindBuffer(35051, transferPbo);
            GL41.glBufferData(35051, (long)(pboWidth * pboHeight) * 4L, 35045);
            GL41.glBindBuffer(35051, 0);
        }
        try {
            @NotNull File screenshotsDir = new File(mcDir, "screenshots");
            screenshotsDir.mkdir();
            @NotNull String dateString = dateFormat.format(new Date());
            int id = 1;
            while ((destFile = new File(screenshotsDir, dateString + (String)(id != 1 ? "_" + id : "") + ".png")).exists()) {
                ++id;
            }
            @Nullable FrameBuffer frameBuffer = ((ShadersRenderer)mc.renderer).getGameFrameBuffer();
            if (frameBuffer == null) {
                throw new IllegalStateException("Game frame buffer is null!");
            }
            frameBuffer.bind();
            GL41.glBindBuffer(35051, transferPbo);
            fence = GL41.glFenceSync(37143, 0);
            GL41.glPixelStorei(3333, 1);
            GL41.glPixelStorei(3317, 1);
            GL41.glReadPixels(0, 0, width, height, 6408, 5121, 0L);
            frameBuffer.unbind();
            GL41.glBindBuffer(35051, 0);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save screenshot!", exception);
        }
    }

    @Nullable
    public static String tickScreenShot() {
        block8: {
            if (fence < 0L) {
                return null;
            }
            int syncResult = GL41.glClientWaitSync(fence, 0, 0L);
            if (syncResult == 37146 || syncResult == 37148) {
                GL41.glDeleteSync(fence);
                fence = -1L;
                GL41.glBindBuffer(35051, transferPbo);
                @NotNull ByteBuffer pboBuffer = Objects.requireNonNull(GL41.glMapBuffer(35051, 35000));
                @NotNull ByteBuffer flipBuffer = MemoryUtil.memCalloc(pboWidth * pboHeight * 4);
                for (int y = 0; y < pboHeight; ++y) {
                    int index = y * pboWidth * 4;
                    flipBuffer.put(index, pboBuffer, pboHeight * pboWidth * 4 - (y + 1) * pboWidth * 4, pboWidth * 4);
                }
                if (!STBImageWrite.stbi_write_png(destFile.getAbsolutePath(), pboWidth, pboHeight, 4, flipBuffer, pboWidth * 4)) {
                    LOGGER.error("Failed to save screenshot!");
                    return "Failed to save screenshot.";
                }
                MemoryUtil.memFree(flipBuffer);
                GL41.glUnmapBuffer(35051);
                GL41.glBindBuffer(35051, 0);
                try {
                    boolean copiedImage = FileOpener.toClipboard(destFile.getAbsolutePath());
                    if (copiedImage) {
                        return "Saved screenshot as " + destFile.getName() + " and copied to clipboard.";
                    }
                    break block8;
                }
                catch (Exception e) {
                    return "Saved screenshot as " + destFile.getName();
                }
            }
            if (syncResult == 37149) {
                GL41.glDeleteSync(fence);
                fence = -1L;
                throw new IllegalStateException("PBO sync wait failed!");
            }
        }
        return null;
    }
}

