/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.EntityPrimedTNT;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFireStriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicTNT
extends BlockLogic {
    public BlockLogicTNT(@NotNull Block<?> block) {
        super(block, Materials.EXPLOSIVE);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        super.onPlacedByWorld(world, tilePos);
        if (world.hasNeighborSignal(tilePos)) {
            this.ignite(world, tilePos, true);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (world.hasNeighborSignal(tilePos)) {
            this.ignite(world, tilePos, true);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.EXPLOSION) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this)};
    }

    @Override
    public void onDestroyedByExplosion(@NotNull World world, @NotNull TilePosc tilePos) {
        EntityPrimedTNT entity = new EntityPrimedTNT(world, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f);
        entity.fuse = world.rand.nextInt(entity.fuse / 4) + entity.fuse / 8;
        world.entityJoinedWorld(entity);
    }

    public void ignite(@NotNull World world, @NotNull TilePosc tilePos, boolean sound) {
        this.ignite(world, null, tilePos, sound);
    }

    public void ignite(@NotNull World world, @Nullable Player player, @NotNull TilePosc tilePos, boolean sound) {
        if (world.isClientSide) {
            if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFireStriker) {
                player.inventory.getCurrentItem().damageItem(1, player);
            }
            return;
        }
        world.setBlockTypeNotify(tilePos, Blocks.AIR);
        EntityPrimedTNT tnt = new EntityPrimedTNT(world, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f);
        world.entityJoinedWorld(tnt);
        if (sound) {
            world.playSoundAtEntity(null, tnt, "tile.tnt.fuse", 1.0f, 1.0f);
        }
        if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFireStriker) {
            player.inventory.getCurrentItem().damageItem(1, player);
        }
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ItemFireStriker) {
            world.setBlockData(tilePos, 1);
        }
        super.onAttacked(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemFireStriker) {
            this.ignite(world, player, tilePos, true);
            return true;
        }
        return super.onInteracted(world, tilePos, player, side, xHit, yHit);
    }
}

