/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.material.ArmorMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IArmorItem<T extends IArmorShape>
extends IItemConvertible {
    @Override
    @NotNull
    public Item asItem();

    @Nullable
    public ArmorMaterial getArmorMaterial();

    @NotNull
    public T getArmorShape();

    default public int armorPieceProtection() {
        return this.getArmorShape().getProtectionValue();
    }

    default public float getArmorPieceProtectionPercentage() {
        return (float)this.armorPieceProtection() / 20.0f;
    }
}

