/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.gamemode;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.GamemodeBuilder;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Gamemodes {
    @NotNull
    public static final Gamemode SURVIVAL = Gamemodes.register("minecraft:gamemode/survival", new GamemodeBuilder("gamemode.survival", Gamemodes::survivalInventory).withBlockConsumption().withBlockBreakingAnimation().withToolDurability().withItemDrops().withHostileMobs().build());
    @NotNull
    public static final Gamemode CREATIVE = Gamemodes.register("minecraft:gamemode/creative", new GamemodeBuilder("gamemode.creative", Gamemodes::creativeInventory).withInvulnerablePlayer().withPlayerFlight().withFireImmunity().withInstantPortalTravel().withBlockReachDistance(6.0f).withEntityReachDistance(4.5f).build());
    @NotNull
    public static final Gamemode HARDCORE = Gamemodes.register("minecraft:gamemode/hardcore", new GamemodeBuilder("gamemode.hardcore", Gamemodes::survivalInventory).withBlockConsumption().withBlockBreakingAnimation().withToolDurability().withItemDrops().withHostileMobs().withPermaDeath().build());
    @NotNull
    public static final Gamemode ADVENTURE = Gamemodes.register("minecraft:gamemode/adventure", new GamemodeBuilder("gamemode.adventure", Gamemodes::survivalInventory).withBlockConsumption().withBlockBreakingAnimation().withToolDurability().withItemDrops().withHostileMobs().withProperToolNeededToMine().build());
    @NotNull
    public static final Gamemode SPECTATOR = Gamemodes.register("minecraft:gamemode/spectator", new GamemodeBuilder("gamemode.spectator", Gamemodes::survivalInventory).withInvulnerablePlayer().withPlayerFlight().withFireImmunity().withInstantPortalTravel().withBlockReachDistance(5000.0f).withEntityReachDistance(5000.0f).withNoInteraction().build());

    @NotNull
    public static Gamemode register(@NotNull String id, @NotNull Gamemode gamemode) {
        Registries.GAMEMODES.register(id, gamemode);
        return gamemode;
    }

    public static void init() {
    }

    @Nullable
    public static Gamemode getGamemodeByLegacyId(int id) {
        return switch (id) {
            case 0 -> SURVIVAL;
            case 1 -> CREATIVE;
            case 2 -> HARDCORE;
            case 3 -> ADVENTURE;
            case 4 -> SPECTATOR;
            default -> null;
        };
    }

    @NotNull
    private static MenuInventory survivalInventory(@NotNull ContainerInventory inventory) {
        return new MenuInventory(inventory);
    }

    @NotNull
    private static MenuInventory creativeInventory(@NotNull ContainerInventory inventory) {
        return new MenuInventoryCreative(inventory);
    }

    private Gamemodes() {
    }
}

