/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.cover.GuidebookSectionCover;
import net.minecraft.client.gui.guidebook.crafting.GuidebookSectionCrafting;
import net.minecraft.client.gui.guidebook.index.GuidebookSectionIndex;
import net.minecraft.client.gui.guidebook.mobs.GuidebookSectionMob;
import net.minecraft.client.gui.guidebook.search.GuidebookSectionSearch;
import net.minecraft.client.gui.guidebook.smelting.GuidebookSectionBlastSmelting;
import net.minecraft.client.gui.guidebook.smelting.GuidebookSectionSmelting;
import net.minecraft.client.gui.guidebook.trommeling.GuidebookSectionTrommel;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class GuidebookSections {
    private static boolean initialized = false;
    private static List<GuidebookSection> sectionList = new ArrayList<GuidebookSection>();
    public static GuidebookSectionCover COVER;
    public static GuidebookSectionIndex INDEX;
    public static GuidebookSectionSearch SEARCH;
    public static GuidebookSectionMob MOB;
    public static GuidebookSectionCrafting CRAFTING;
    public static GuidebookSectionSmelting FURNACE;
    public static GuidebookSectionBlastSmelting BLAST_FURNACE;
    public static GuidebookSectionTrommel TROMMEL;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        COVER = GuidebookSections.register(new GuidebookSectionCover());
        INDEX = GuidebookSections.register(new GuidebookSectionIndex());
        SEARCH = GuidebookSections.register(new GuidebookSectionSearch());
        CRAFTING = GuidebookSections.register(new GuidebookSectionCrafting());
        FURNACE = GuidebookSections.register(new GuidebookSectionSmelting("guidebook.section.furnace", new ItemStack(Blocks.FURNACE_STONE_ACTIVE), 0x606060, 0x404040));
        BLAST_FURNACE = GuidebookSections.register(new GuidebookSectionBlastSmelting("guidebook.section.blast_furnace", new ItemStack(Blocks.FURNACE_BLAST_ACTIVE), 0xA0A0A0, 0x808080));
        TROMMEL = GuidebookSections.register(new GuidebookSectionTrommel("guidebook.section.trommel", new ItemStack(Blocks.TROMMEL_ACTIVE), 0x202020, 0x404040));
        MOB = GuidebookSections.register(new GuidebookSectionMob());
    }

    @NotNull
    public static <T extends GuidebookSection> T register(@NotNull T section) {
        sectionList.add(section);
        return section;
    }

    public static List<GuidebookSection> getSectionList() {
        return Collections.unmodifiableList(sectionList);
    }
}

