/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.client.gui.server.ServerManager;
import net.minecraft.client.net.thread.ThreadPingServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ServerListenerThread
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public final ScreenSelectServer attachedScreen;
    @NotNull
    public final ServerManager serverManager;
    @NotNull
    public final Map<ServerEntry, ThreadPingServer> pingThreads = new HashMap<ServerEntry, ThreadPingServer>();
    public boolean keepAlive = true;
    protected MulticastSocket multicastSocket = null;
    protected byte[] buf = new byte[256];

    public ServerListenerThread(@NotNull ScreenSelectServer attachedScreen) {
        this.attachedScreen = attachedScreen;
        this.serverManager = attachedScreen.serverManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean multiCastAlive = false;
        InetAddress group = null;
        try {
            this.multicastSocket = new MulticastSocket(4445);
            group = InetAddress.getByName("224.0.2.61");
            this.multicastSocket.joinGroup(group);
            multiCastAlive = true;
        }
        catch (IOException e) {
            LOGGER.error("", e);
        }
        while (this.keepAlive) {
            try {
                this.serverManager.idToEntryLock.lock();
                try {
                    for (ServerEntry entry : this.serverManager.idToEntryMap.values()) {
                        if (!entry.dirty || this.pingThreads.containsKey(entry)) continue;
                        entry.dirty = false;
                        Map<ServerEntry, ThreadPingServer> map = this.pingThreads;
                        synchronized (map) {
                            ThreadPingServer threadPingServer2 = new ThreadPingServer(this, entry);
                            this.pingThreads.put(entry, threadPingServer2);
                            threadPingServer2.start();
                        }
                    }
                }
                finally {
                    this.serverManager.idToEntryLock.unlock();
                }
                if (multiCastAlive) {
                    try {
                        DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
                        this.multicastSocket.receive(packet);
                        String received = new String(packet.getData(), 0, packet.getLength());
                        if ("end".equals(received)) {
                            multiCastAlive = false;
                        } else {
                            this.receivedLocalServer(packet, received);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("", e);
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("", e);
            }
        }
        try {
            if (group != null) {
                this.multicastSocket.leaveGroup(group);
            }
        }
        catch (IOException e) {
            LOGGER.error("", e);
        }
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
        }
    }

    public void receivedLocalServer(DatagramPacket packet, String localServerBroadcast) {
        String ip;
        String motd = null;
        if (localServerBroadcast.contains("[MOTD]")) {
            int start = localServerBroadcast.indexOf("[MOTD]");
            int end = localServerBroadcast.indexOf("[/MOTD]");
            if (start != -1 && end != -1) {
                motd = localServerBroadcast.substring(start + "[MOTD]".length(), end);
            }
        }
        String port = null;
        if (localServerBroadcast.contains("[AD]")) {
            int start = localServerBroadcast.indexOf("[AD]");
            int end = localServerBroadcast.indexOf("[/AD]");
            if (start != -1 && end != -1) {
                port = localServerBroadcast.substring(start + "[AD]".length(), end);
            }
        }
        String name = null;
        if (localServerBroadcast.contains("[NAME]")) {
            int start = localServerBroadcast.indexOf("[NAME]");
            int end = localServerBroadcast.indexOf("[/NAME]");
            if (start != -1 && end != -1) {
                name = localServerBroadcast.substring(start + "[NAME]".length(), end);
            }
        }
        if ((ip = packet.getAddress().getHostAddress()) != null && port != null) {
            int portInt;
            try {
                portInt = Integer.parseInt(port);
            }
            catch (Exception e) {
                return;
            }
            this.serverManager.onLocalScanned(ip, portInt, motd, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingServerInfo(ServerEntry server) {
        Map<ServerEntry, ThreadPingServer> map = this.pingThreads;
        synchronized (map) {
            ThreadPingServer pingServer = this.pingThreads.remove(server);
            if (pingServer != null) {
                pingServer.interrupt();
            }
        }
    }
}

