/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

public enum InventoryAction {
    CLICK_LEFT(false),
    CLICK_RIGHT(false),
    DROP_HELD_SINGLE(false),
    DROP_HELD_STACK(false),
    HOTBAR_ITEM_SWAP(false),
    DRAG_ITEMS_ALL(false),
    DRAG_ITEMS_ONE(false),
    PICKUP_SIMILAR(false),
    MOVE_STACK(false),
    MOVE_SINGLE_ITEM(false),
    MOVE_ALL(false),
    MOVE_SIMILAR(false),
    DROP(false),
    INTERACT_SLOT(false),
    INTERACT_GRABBED(false),
    EQUIP_ARMOR(false),
    SORT(false),
    LOCK(false),
    CREATIVE_GRAB(true),
    CREATIVE_MOVE(true),
    CREATIVE_DELETE(true),
    CREATIVE_DRAG(true);

    private static final InventoryAction[] actions;
    private int id;
    private final boolean requireCreative;

    private static void setId(InventoryAction action, int id) {
        InventoryAction.actions[id] = action;
        action.id = id;
    }

    private InventoryAction(boolean requireCreative) {
        this.requireCreative = requireCreative;
    }

    public int getId() {
        return this.id;
    }

    public boolean requireCreative() {
        return this.requireCreative;
    }

    public static InventoryAction get(int id) {
        if (id < 0 || id >= actions.length) {
            return null;
        }
        return actions[id];
    }

    static {
        actions = new InventoryAction[32];
        InventoryAction.setId(CLICK_LEFT, 0);
        InventoryAction.setId(CLICK_RIGHT, 1);
        InventoryAction.setId(DROP_HELD_SINGLE, 2);
        InventoryAction.setId(DROP_HELD_STACK, 3);
        InventoryAction.setId(HOTBAR_ITEM_SWAP, 4);
        InventoryAction.setId(DRAG_ITEMS_ALL, 5);
        InventoryAction.setId(DRAG_ITEMS_ONE, 6);
        InventoryAction.setId(PICKUP_SIMILAR, 7);
        InventoryAction.setId(MOVE_STACK, 8);
        InventoryAction.setId(MOVE_SINGLE_ITEM, 9);
        InventoryAction.setId(MOVE_ALL, 10);
        InventoryAction.setId(MOVE_SIMILAR, 11);
        InventoryAction.setId(DROP, 12);
        InventoryAction.setId(CREATIVE_GRAB, 13);
        InventoryAction.setId(CREATIVE_MOVE, 14);
        InventoryAction.setId(CREATIVE_DELETE, 15);
        InventoryAction.setId(CREATIVE_DRAG, 20);
        InventoryAction.setId(INTERACT_SLOT, 16);
        InventoryAction.setId(INTERACT_GRABBED, 17);
        InventoryAction.setId(EQUIP_ARMOR, 18);
        InventoryAction.setId(SORT, 19);
        InventoryAction.setId(LOCK, 20);
    }
}

