/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;

public class Scale2D<T extends Noise2D>
implements Noise2D {
    @NotNull
    protected final T noise;
    protected final double xScale;
    protected final double zScale;

    public Scale2D(@NotNull T noise, double xScale, double zScale) {
        this.noise = noise;
        this.xScale = 1.0 / xScale;
        this.zScale = 1.0 / zScale;
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return this.noise.getRange2D();
    }

    @Override
    public double getValue(double x, double z) {
        return this.noise.getValue(x * this.xScale, z * this.zScale);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        return this.noise.addRegion(out, x, z, xSize, zSize, xScale * this.xScale, zScale * this.zScale, amplitude);
    }
}

