/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.worldsettings.settingnode.ValueNodeComponent;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.ValueSettingNode;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanValueNodeComponent
extends ValueNodeComponent<Boolean> {
    @NotNull
    private final SwitchElement button = new SwitchElement(0, 0, 0, 150, 20, false, "", "");

    public BooleanValueNodeComponent(@NotNull @NotNull ValueSettingNode<@NotNull Boolean> valueNode, int nestLevel) {
        super(valueNode, nestLevel);
    }

    @Override
    public void reset() {
        super.reset();
        this.onChange();
    }

    @Override
    public void onUpdate(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        super.onUpdate(dimension, worldConfiguration);
        this.onChange();
    }

    @Override
    protected boolean buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        worldConfiguration.getDimensionSettings(dimension).setNodeValue(this.getNode(), Boolean.valueOf((Boolean)worldConfiguration.getDimensionSettings(dimension).getNodeValue(this.getNode(), worldConfiguration) == false));
        this.onChange();
        return true;
    }

    @Override
    protected void renderButtonInner(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(MC, x + relativeMouseX, y + relativeMouseY);
    }

    private void onChange() {
        this.button.setOn((Boolean)this.getValue());
        this.button.displayString = this.getNode().getValueText((Boolean)this.getValue()).toString();
    }
}

