/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.option.OptionToggleable;
import org.jetbrains.annotations.NotNull;

public class OptionGuiScale
extends OptionToggleable<Integer> {
    public OptionGuiScale(String name, Integer defaultValue) {
        super(name, defaultValue, new Integer[1]);
    }

    @Override
    public void toggle() {
        this.toggle(1);
    }

    @Override
    public void toggle(int delta) {
        int size = this.size();
        this.setValueWithIndex((this.getValueIndex() + delta) % size);
    }

    @Override
    public int getValueIndex() {
        if ((Integer)this.value == 0) {
            return 0;
        }
        return this.size() - (Integer)this.value;
    }

    @Override
    public void setValueWithIndex(int i) {
        this.value = i != 0 ? Integer.valueOf(this.size() - i) : Integer.valueOf(i);
    }

    @Override
    public int size() {
        Minecraft mc = Minecraft.getMinecraft();
        int width = mc.resolution.getWidthScreenCoords();
        int height = mc.resolution.getHeightScreenCoords();
        return ScaledResolution.getMaxScale(width, height);
    }

    @Override
    public boolean isSlider() {
        return true;
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        this.value = Integer.parseInt(string);
    }
}

