/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.ListSettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNodeVisibilityListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericSettingNode
implements KeyedSettingNode {
    @NotNull
    private final String key;
    @Nullable
    private SettingNodeChildrenProvider childrenProvider = null;
    @NotNull
    private SettingNodeVisibilityListener selfVisibilityListener = SettingNodeVisibilityListener::alwaysVisible;

    public GenericSettingNode(@NotNull String key) {
        this.key = key;
        KeyedSettingNode.checkKeyIsUnique(key);
    }

    @Override
    @NotNull
    public SettingNode withChild(@NotNull SettingNode child) {
        if (this.childrenProvider != null && !(this.childrenProvider instanceof ListSettingNodeChildrenProvider)) {
            throw new RuntimeException("Incorrect child provider to manually add child!");
        }
        if (this.childrenProvider == null) {
            this.childrenProvider = new ListSettingNodeChildrenProvider();
        }
        @NotNull ListSettingNodeChildrenProvider childrenProvider = (ListSettingNodeChildrenProvider)this.childrenProvider;
        childrenProvider.withChild(child);
        return this;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public SettingNodeChildrenProvider getChildrenProvider() {
        return this.childrenProvider;
    }

    @NotNull
    public final GenericSettingNode withChildrenProvider(@NotNull SettingNodeChildrenProvider childrenProvider) {
        this.childrenProvider = childrenProvider;
        return this;
    }

    @Override
    public boolean isVisible(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.selfVisibilityListener.isVisible(config);
    }

    @NotNull
    public final GenericSettingNode withVisibilityListener(@NotNull SettingNodeVisibilityListener visibilityListener) {
        this.selfVisibilityListener = visibilityListener;
        return this;
    }
}

