/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SliderElement;
import net.minecraft.client.gui.modelviewer.elements.IActionListener;
import net.minecraft.client.gui.modelviewer.elements.IKeyListener;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.option.OptionFloat;

public class ListenerSliderElement
extends SliderElement
implements IListenerElement<ListenerSliderElement> {
    private IActionListener action;
    private IKeyListener keyListener;
    private Runnable onValueChanged;

    public ListenerSliderElement(int id, int xPosition, int yPosition, OptionFloat optionFloat) {
        super(id, xPosition, yPosition, optionFloat);
    }

    public ListenerSliderElement(int id, int xPosition, int yPosition, int width, int height, OptionFloat optionFloat) {
        super(id, xPosition, yPosition, width, height, optionFloat);
    }

    public ListenerSliderElement(int id, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id, xPosition, yPosition, width, height, text, defaultValue);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        double _val = this.sliderValue;
        boolean flag = super.mouseClicked(mc, mouseX, mouseY);
        if (flag && this.action != null) {
            this.action.onInteract();
            if (this.sliderValue != _val) {
                this.onValueChanged();
            }
        }
        return flag;
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        double _val = this.sliderValue;
        super.mouseDragged(mc, mouseX, mouseY);
        if (this.sliderValue != _val) {
            this.onValueChanged();
        }
    }

    @Override
    public ListenerSliderElement setActionListener(IActionListener listener) {
        this.action = listener;
        return this;
    }

    @Override
    public ListenerSliderElement setKeyListener(IKeyListener listener) {
        this.keyListener = listener;
        return this;
    }

    @Override
    public ListenerSliderElement setOnValueChanged(Runnable runnable) {
        this.onValueChanged = runnable;
        return this;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (this.keyListener != null) {
            this.keyListener.onKeyPressed(key);
        }
    }

    @Override
    public void onValueChanged() {
        if (this.onValueChanged != null) {
            this.onValueChanged.run();
        }
    }
}

