/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.worldsettings.settingnode.ValueNodeComponent;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.ListValueSettingNode;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListValueNodeComponent<T>
extends ValueNodeComponent<T> {
    @NotNull
    private final ButtonElement button = new ButtonElement(0, 0, 0, 150, 20, "");

    public ListValueNodeComponent(@NotNull ListValueSettingNode<T> valueNode, int nestLevel) {
        super(valueNode, nestLevel);
    }

    @Override
    public void reset() {
        super.reset();
        this.button.displayString = this.getNode().getValueText(this.getValue()).toString();
    }

    @Override
    public void onUpdate(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        super.onUpdate(dimension, worldConfiguration);
        this.button.displayString = this.getNode().getValueText(this.getValue()).toString();
    }

    @Override
    protected boolean buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        @NotNull ListValueSettingNode node = (ListValueSettingNode)this.getNode();
        @Nullable Dimension dimension = this.getDimension();
        @Nullable WorldConfiguration worldConfiguration = this.getWorldConfiguration();
        assert (dimension != null && worldConfiguration != null);
        @NotNull T currentValue = this.getValue();
        int selected = 0;
        @NotNull List<@NotNull T> values2 = node.getValues(dimension, worldConfiguration);
        @NotNull String @NotNull [] keys2 = new String[values2.size()];
        for (int i = 0; i < keys2.length; ++i) {
            @NotNull T value = values2.get(i);
            @NotNull Text valueText = node.getValueText(value);
            keys2[i] = valueText.toString();
            if (value != currentValue && !value.equals(currentValue) && !currentValue.equals(value)) continue;
            selected = i;
        }
        @NotNull PopupScreen popup = new PopupBuilder(Objects.requireNonNull(ListValueNodeComponent.MC.currentScreen), 150).closeOnEsc(0).closeOnClickOut(0).withList("settingList", 140, keys2, null, selected, true).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                int index = (Integer)Objects.requireNonNull(results.get("settingList"));
                this.getWorldConfiguration().getDimensionSettings(Objects.requireNonNull(this.getDimension())).setNodeValue(node, values2.get(index));
            }
        }).build();
        MC.displayScreen(popup);
        return true;
    }

    @Override
    protected void renderButtonInner(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(MC, x + relativeMouseX, y + relativeMouseY);
    }
}

