/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import net.minecraft.core.world.saveddata.maps.MapWaypoint;
import org.joml.Math;

public class MapItemRenderer {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;
    public static final int IMAGE_AREA = 16384;
    private final int[] mapImageData = new int[16384];
    private TextureBuffered mapTexture;

    public void preRender() {
        if (this.mapTexture == null) {
            this.mapTexture = Minecraft.getMinecraft().textureManager.loadBufferedTexture(new BufferedImage(128, 128, 2));
            for (int i = 0; i < 16384; ++i) {
                this.mapImageData[i] = 0;
            }
        }
    }

    public void renderMap(TessellatorGeneral tessellator, ItemMapSavedData data) {
        float f4;
        float f3;
        float f2;
        this.preRender();
        TextureManager textureManager = Minecraft.getMinecraft().textureManager;
        for (int i = 0; i < 16384; ++i) {
            byte colorIndex = data.colors[i];
            if (colorIndex >> 2 == 0) {
                this.mapImageData[i] = (i + i / 128 & 1) * 8 + 16 << 24;
                continue;
            }
            int col = MaterialColor.getColorFromIndex(colorIndex >> 2);
            int i1 = colorIndex & 3;
            int shade = 220;
            if (i1 == 2) {
                shade = 255;
            }
            if (i1 == 0) {
                shade = 180;
            }
            int red = Color.redFromInt(col) * shade / 255;
            int green = Color.greenFromInt(col) * shade / 255;
            int blue = Color.blueFromInt(col) * shade / 255;
            this.mapImageData[i] = Color.intToIntARGB(255, red, green, blue);
        }
        textureManager.updateTextureData(this.mapImageData, 128, 128, this.mapTexture.id());
        int j = 0;
        int k = 0;
        float f = 0.0f;
        this.mapTexture.bind();
        GLRenderer.enableState(State.BLEND);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((float)j + f, (float)(k + 128) - f, -0.01, 0.0, 1.0);
        tessellator.addVertexWithUV((float)(j + 128) - f, (float)(k + 128) - f, -0.01, 1.0, 1.0);
        tessellator.addVertexWithUV((float)(j + 128) - f, (float)k + f, -0.01, 1.0, 0.0);
        tessellator.addVertexWithUV((float)j + f, (float)k + f, -0.01, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.disableState(State.BLEND);
        textureManager.bindTexture(textureManager.loadTexture("/assets/minecraft/textures/misc/mapicons.png"));
        for (MapWaypoint mapWaypoint : data.mapWaypoints) {
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)j + (float)mapWaypoint.mapCoordX / 2.0f + 64.0f, (float)k + (float)mapWaypoint.mapCoordZ / 2.0f + 64.0f, -0.02f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(180.0f));
            GLRenderer.modelM4f().scale(4.0f, 4.0f, 3.0f);
            GLRenderer.modelM4f().translate(-0.125f, 0.125f, 0.0f);
            double zIndex = 0.0;
            float f1 = 0.25f;
            f2 = 0.25f;
            f3 = 0.5f;
            f4 = 0.5f;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-1.0, 1.0, zIndex, f1, f2);
            tessellator.addVertexWithUV(1.0, 1.0, zIndex, f3, f2);
            tessellator.addVertexWithUV(1.0, -1.0, zIndex, f3, f4);
            tessellator.addVertexWithUV(-1.0, -1.0, zIndex, f1, f4);
            tessellator.draw();
            GLRenderer.popFrame();
        }
        textureManager.bindTexture(textureManager.loadTexture("/assets/minecraft/textures/misc/mapicons.png"));
        for (ItemMapSavedData.MapDecoration decoration : data.decorations) {
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)j + (float)decoration.x / 2.0f + 64.0f, (float)k + (float)decoration.y / 2.0f + 64.0f, -0.02f);
            GLRenderer.modelM4f().rotateZ((float)decoration.rot * ((float)java.lang.Math.PI * 2) / 16.0f);
            GLRenderer.modelM4f().scale(4.0f, 4.0f, 3.0f);
            GLRenderer.modelM4f().translate(-0.125f, 0.125f, 0.0f);
            double zIndex = -1.0;
            float f1 = (float)(decoration.type % 4) / 4.0f;
            f2 = (float)(decoration.type / 4) / 4.0f;
            f3 = (float)(decoration.type % 4 + 1) / 4.0f;
            f4 = (float)(decoration.type / 4 + 1) / 4.0f;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-1.0, 1.0, zIndex, f1, f2);
            tessellator.addVertexWithUV(1.0, 1.0, zIndex, f3, f2);
            tessellator.addVertexWithUV(1.0, -1.0, zIndex, f3, f4);
            tessellator.addVertexWithUV(-1.0, -1.0, zIndex, f1, f4);
            tessellator.draw();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLRenderer.popFrame();
        }
        GLRenderer.pushFrame();
        textureManager.bindTexture(textureManager.loadTexture("/assets/minecraft/textures/misc/flagicon.png"));
        for (MapWaypoint mapWaypoint : data.mapWaypoints) {
            GLRenderer.pushFrame();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    Color color = Colors.allFlagColors[15 - mapWaypoint.colors[x * 3 + y]];
                    float red = (float)color.getRed() / 255.0f;
                    float green = (float)color.getGreen() / 255.0f;
                    float blue = (float)color.getBlue() / 255.0f;
                    GLRenderer.setColor4f(red, green, blue, 1.0f);
                    GLRenderer.pushFrame();
                    GLRenderer.modelM4f().translate((float)(j + x % 3) + (float)mapWaypoint.mapCoordX / 2.0f + 64.0f, (float)(k + y % 3) + (float)mapWaypoint.mapCoordZ / 2.0f + 64.0f, -0.0f);
                    GLRenderer.modelM4f().rotateZ(Math.toRadians(180.0f));
                    GLRenderer.modelM4f().scale(0.5f, 0.5f, 0.5f);
                    GLRenderer.modelM4f().translate(0.0f, 4.0f, 0.0f);
                    double zIndex = -0.1;
                    float flagXMin = (float)((x + y) % 4) / 4.0f;
                    float flagYMin = (float)((x + y) / 4) / 4.0f;
                    float flagXMax = (float)((x + y) % 4 + 1) / 4.0f;
                    float flagYMax = (float)((x + y) / 4 + 1) / 4.0f;
                    tessellator.startDrawingQuads();
                    tessellator.addVertexWithUV(-1.0, 1.0, zIndex, flagXMin, flagYMin);
                    tessellator.addVertexWithUV(1.0, 1.0, zIndex, flagXMax, flagYMin);
                    tessellator.addVertexWithUV(1.0, -1.0, zIndex, flagXMax, flagYMax);
                    tessellator.addVertexWithUV(-1.0, -1.0, zIndex, flagXMin, flagYMax);
                    tessellator.draw();
                    GLRenderer.popFrame();
                }
            }
            GLRenderer.popFrame();
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.modelM4f().translate(0.0f, 0.0f, -0.04f);
        GLRenderer.modelM4f().scale(1.0f, 1.0f, 1.0f);
        GLRenderer.popFrame();
    }
}

