/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDiscMusic
extends Item {
    @Nullable
    public final String recordName;
    @Nullable
    public final String recordAuthor;

    public ItemDiscMusic(@NotNull String name, @NotNull String namespaceId, int id, @Nullable String recordName, @Nullable String recordAuthor) {
        super(name, namespaceId, id);
        this.recordName = recordName;
        this.recordAuthor = recordAuthor;
        this.maxStackSize = 1;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (world.getBlockType(blockPos) == Blocks.JUKEBOX && world.getBlockData(blockPos) == 0) {
            if (!world.isClientSide) {
                Blocks.JUKEBOX.getLogic().playRecord(world, new TilePos(blockPos), this.id);
                world.playBlockEvent(null, blockPos, 1005, this.id);
                selfStack.consumeItem(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        TilePos pos = blockPos.add(direction, new TilePos());
        if (world.getBlockType(pos) == Blocks.JUKEBOX && world.getBlockData(pos) == 0) {
            Blocks.JUKEBOX.getLogic().playRecord(world, new TilePos(pos), this.id);
            world.playBlockEvent(null, pos, 1005, this.id);
            selfStack.consumeItem(null);
        }
    }
}

